<?php

include("db_connect.php");

$receipt_id = $_GET['receipt_id'];

$query = "SELECT s.*, p.name AS product_name
          FROM sales s
          JOIN products p ON s.product_id = p.id
          WHERE s.receipt_id = '$receipt_id'";

$result = mysqli_query($conn, $query);
$sales = [];
$total = 0;
$profit = 0;

while ($row = mysqli_fetch_assoc($result)) {
    $sales[] = $row;
    $total += $row['total_sale'];
    $profit += $row['profit'];
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Receipt</title>
    <style>
        .receipt {
            width: 300px;
            margin: 0 auto;
            font-family: 'Courier New', Courier, monospace;
            border: 1px solid #ccc;
            padding: 15px;
            background: white;
        }

        .receipt h2 {
            text-align: center;
            margin-bottom: 10px;
        }

        .receipt p,
        .receipt h3 {
            font-size: 14px;
            margin: 4px 0;
        }

        .receipt table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        .receipt th,
        .receipt td {
            font-size: 13px;
            padding: 4px;
            border-bottom: 1px dashed #ccc;
            text-align: left;
        }

        .receipt th {
            background: #f0f0f0;
        }

        .receipt button {
            margin-top: 15px;
            padding: 8px 12px;
            font-size: 14px;
            background-color: #28a745;
            color: white;
            border: none;
            cursor: pointer;
            display: block;
            width: 100%;
        }

        @media print {
            body * {
                visibility: hidden;
            }
            .receipt, .receipt * {
                visibility: visible;
            }
            .receipt {
                position: absolute;
                left: 0;
                top: 0;
            }
            .receipt button {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="receipt">
        <h2>Receipt ID: <?= $receipt_id ?></h2>
        <p>Date: <?= $sales[0]['sale_datetime'] ?? '' ?></p>
        <p>Cashier: <?= $sales[0]['cashier'] ?? '' ?></p>

        <table>
            <tr>
                <th>Product</th>
                <th>Qty</th>
                <th>Price</th>
                <th>Total</th>
            </tr>
            <?php foreach ($sales as $sale): ?>
                <tr>
                    <td><?= $sale['product_name'] ?></td>
                    <td><?= $sale['quantity'] ?></td>
                    <td><?= number_format($sale['selling_price'], 2) ?></td>
                    <td><?= number_format($sale['total_sale'], 2) ?></td>
                </tr>
            <?php endforeach; ?>
        </table>

        <h3>Total: KES <?= number_format($total, 2) ?></h3>
        <button onclick="window.print()">Print Receipt</button>
    </div>
    <?php include 'footer.php'; ?>
</body>
</html>