<?php
session_start();

if (!isset($_SESSION['username']) || $_SESSION['role'] !== 'admin') {
    header("Location: login.php");
    exit();
}

require 'db_connect.php';

// Pagination settings
$limit  = 10;
$page   = isset($_GET['page']) ? intval($_GET['page']) : 1;
$page   = max(1, $page);
$offset = ($page - 1) * $limit;

// Count total records
$total       = $conn->query("SELECT COUNT(*) AS total FROM damages")->fetch_assoc()['total'];
$total_pages = ceil($total / $limit);

// Fetch page data
$res = $conn->query("
    SELECT *
    FROM damages
    ORDER BY damaged_date DESC
    LIMIT $limit OFFSET $offset
");

$rows      = [];
$page_qty  = 0;
$page_loss = 0;

while ($r = $res->fetch_assoc()) {
    $rows[]     = $r;
    $page_qty  += $r['quantity'];
    $page_loss += $r['amount'];
}

// Grand totals
$grand = $conn->query("
    SELECT SUM(quantity) AS qty, SUM(amount) AS lost
    FROM damages
")->fetch_assoc();

$page_title = "Damaged Goods Report";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title><?= htmlspecialchars($page_title) ?></title>
    <?php include("head.php"); ?>

    <style>
        body {
            font-family: 'Poppins', Arial, sans-serif;
            background: var(--bg-main);
            margin: 0;
            color: var(--text-main);
        }

        /* Shift content when sidebar is present */
        .content-area {
            margin-left: 260px;
            padding: 25px 30px;
        }

        @media(max-width:768px){
            .content-area {
                margin-left: 85px;
                padding: 20px;
            }
        }

        .page-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-end;
            flex-wrap: wrap;
            gap: 10px;
            margin-bottom: 18px;
        }

        .page-title {
            font-size: 22px;
            font-weight: 600;
            color: var(--text-heading);
            align-content: center;
        }

        .page-subtitle {
            font-size: 13px;
            color: var(--accent-gold);
            margin-top: 4px;
        }

        /* Card box */
        .card-box {
            width: 100%;
            max-width: 1600px; /* allow a wider layout */
            margin: 0 auto;
            background: var(--bg-card);
            padding:20px 22px;
            border-radius:14px;
            box-shadow:0 4px 14px rgba(0,0,0,0.35);
            border: 1px solid #0a4a85;
            color: var(--text-main);
        }

        body[data-theme="light"] .card-box {
            border-color: rgba(148,163,184,0.55);
            box-shadow: 0 10px 24px rgba(15,23,42,0.10);
        }

        h2 {
            text-align:center;
            font-size:22px;
            color: var(--text-heading);
            font-weight:600;
            margin-bottom: 10px;
        }

        /* Table wrapper */
        .table-wrapper {
            width: 100%;
            overflow-x: auto;
            margin-top: 8px;
        }

        /* Table style */
        table {
            width:100%;
            min-width: 1150px; /* force wide table for better layout */
            margin-top:10px;
            border-collapse:collapse;
            background: var(--bg-card);
            border-radius:10px;
            overflow:hidden;
            box-shadow:0 4px 12px rgba(0,0,0,0.35);
            color: var(--text-main);
        }

        thead tr {
            background: var(--bg-table-head);
        }

        th {
            color: var(--text-heading);
            padding:10px 12px;
            font-size:13px;
            font-weight:600;
            text-align:center;
            border-bottom:1px solid rgba(255,255,255,0.15);
            white-space: nowrap;
        }

        body[data-theme="light"] th {
            border-bottom-color: rgba(0,0,0,0.08);
        }

        td {
            padding:9px 12px;
            text-align:center;
            background: var(--bg-table-row);
            border-bottom:1px solid rgba(255,255,255,0.12);
            color: var(--text-main);
            font-size:13px;
            white-space: nowrap;
        }

        body[data-theme="light"] td {
            border-bottom-color: rgba(0,0,0,0.06);
        }

        /* Product column left aligned */
        td.product-cell {
            text-align:left;
        }

        tbody tr:nth-child(even) {
            background: var(--bg-table-row);
            opacity: 0.96;
        }

        tbody tr:hover {
            background: var(--bg-table-hover);
        }

        .numeric {
            text-align: right;
        }

        /* Totals row */
        .totals-row {
            background: var(--bg-main);
            font-weight:700;
        }

        .totals-row td {
            border-top:1px solid rgba(255,255,255,0.25);
        }

        body[data-theme="light"] .totals-row td {
            border-top-color: rgba(0,0,0,0.10);
        }

        /* Pagination */
        .pagination {
            text-align:center;
            margin-top:18px;
        }

        .pagination a {
            padding:7px 12px;
            background: var(--bg-card);
            color: var(--text-main);
            border-radius:5px;
            margin:3px;
            text-decoration:none;
            border: 1px solid #0a4a85;
            font-size: 13px;
        }

        body[data-theme="light"] .pagination a {
            border-color: rgba(148,163,184,0.55);
        }

        .pagination a.active {
            background:#5a47f5;
            font-weight:700;
            border-color: #5a47f5;
            color: #ffffff;
        }

        .pagination a:hover {
            background: var(--bg-table-hover);
            border-color:#014b94;
        }

        /* Grand totals box */
        .summary-box {
            width:100%;
            max-width: 520px;
            margin:22px auto 10px auto;
            background: var(--bg-card);
            padding:14px 16px;
            border-radius:10px;
            border-left:8px solid var(--accent-gold);
            font-size:15px;
            font-weight:600;
            color: var(--text-main);
            text-align:center;
            box-shadow:0 4px 10px rgba(0,0,0,0.3);
        }

        .summary-box span.label {
            color: var(--text-main);
        }

        .summary-box span.value {
            color: var(--accent-gold);
        }

        footer {
            background: transparent;
        }
    </style>
</head>

<body>

<?php include("sidebar.php"); ?>

<div class="content-area">

    <div class="page-header">
        <div>
            <div class="page-title">Damaged Goods Report</div>
            <div class="page-subtitle">
                Page <?= $page ?> of <?= $total_pages ?> (<?= $limit ?> per page)
            </div>
        </div>
    </div>

    <div class="card-box">

        <h2>Damaged Goods Report</h2>

        <div class="table-wrapper">
            <table>
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Product</th>
                        <th>Qty Damaged</th>
                        <th>Total Loss (KES)</th>
                        <th>Description</th>
                        <th>Cashier</th>
                        <th>Date Reported</th>
                    </tr>
                </thead>
                <tbody>
                <?php if (!empty($rows)): ?>
                    <?php foreach($rows as $row): ?>
                    <tr>
                        <td><?= $row['id'] ?></td>
                        <td class="product-cell"><?= htmlspecialchars($row['product_name']) ?></td>
                        <td class="numeric"><?= number_format($row['quantity']) ?></td>
                        <td class="numeric"><?= number_format($row['amount'],2) ?></td>
                        <td><?= htmlspecialchars($row['description']) ?></td>
                        <td><?= htmlspecialchars($row['cashier']) ?></td>
                        <td><?= htmlspecialchars($row['damaged_date']) ?></td>
                    </tr>
                    <?php endforeach; ?>

                    <tr class="totals-row">
                        <td colspan="2">Page Totals</td>
                        <td class="numeric"><?= number_format($page_qty) ?></td>
                        <td class="numeric">KES <?= number_format($page_loss,2) ?></td>
                        <td colspan="3"></td>
                    </tr>

                <?php else: ?>
                    <tr>
                        <td colspan="7">No damage records found.</td>
                    </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <div class="pagination">
            <?php for($i = 1; $i <= $total_pages; $i++): ?>
                <a href="?page=<?= $i ?>" class="<?= ($i==$page?'active':'') ?>"><?= $i ?></a>
            <?php endfor; ?>
        </div>

        <!-- Grand totals -->
        <div class="summary-box">
            <div>
                <span class="label">Grand Total Damaged Quantity:</span>
                <span class="value"><?= number_format($grand['qty']) ?></span>
            </div>
            <div>
                <span class="label">Grand Total Loss:</span>
                <span class="value">KES <?= number_format($grand['lost'],2) ?></span>
            </div>
        </div>

    </div>

</div>

<?php include("footer.php"); ?>
</body>
</html>
