<?php
session_start();
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit();
}

require 'db_connect.php';

// Top 5 Fast-Moving Products
$topProductsQuery = $conn->query("
    SELECT p.name, SUM(s.quantity) AS total_sold, SUM(s.quantity * s.selling_price) AS total_revenue
    FROM sales s
    JOIN products p ON s.product_id = p.id
    GROUP BY s.product_id
    ORDER BY total_sold DESC
    LIMIT 5
");

// Bottom 5 Slow-Moving Products
$bottomProductsQuery = $conn->query("
    SELECT p.name, SUM(s.quantity) AS total_sold, SUM(s.quantity * s.selling_price) AS total_revenue
    FROM sales s
    JOIN products p ON s.product_id = p.id
    GROUP BY s.product_id
    HAVING total_sold > 0
    ORDER BY total_sold ASC
    LIMIT 5
");

// optional page title for head.php
$page_title = "Top & Bottom Products";
?>
<!DOCTYPE html>
<html>
<head>
    <title><?= htmlspecialchars($page_title) ?></title>
    <?php include("head.php"); ?>

    <style>
        body {
            font-family: 'Poppins', Arial, sans-serif;
            background: var(--bg-main);
            margin: 0;
            color: var(--text-main);
        }

        /* content shifted right of sidebar */
        .content-area {
            margin-left: 260px;
            padding: 25px 30px;
        }
        @media (max-width: 768px) {
            .content-area {
                margin-left: 80px;
                padding: 20px;
            }
        }

        /* centered main header */
        .page-header {
            text-align: center;
            margin-bottom: 20px;
        }
        .page-title {
            font-size: 22px;
            font-weight: 600;
            color: var(--text-heading);
        }
        .page-subtitle {
            font-size: 13px;
            color: var(--accent-gold);
            margin-top: 4px;
        }

        /* container for the cards */
        .cards-wrapper {
            width: 100%;
            max-width: 1200px;
            margin: 0 auto;
            display: grid;
            grid-template-columns: minmax(0, 1fr);
            gap: 20px;
        }

        /* card box style */
        .card-box {
            background: var(--bg-card);
            max-width: 1600px;
            border-radius: 14px;
            padding: 18px 20px;
            box-shadow: 0 4px 14px rgba(0,0,0,0.35);
            border: 1px solid #0a4a85;
            color: var(--text-main);
        }

        body[data-theme="light"] .card-box {
            border-color: rgba(148,163,184,0.55);
            box-shadow: 0 10px 24px rgba(15,23,42,0.10);
        }

        .card-title {
            font-size: 16px;
            font-weight: 500;
            color: var(--text-heading);
            margin-bottom: 10px;
            border-left: 4px solid var(--accent-gold);
            padding-left: 8px;
        }

        /* table wrapper */
        .table-wrapper {
            width: 100%;
            overflow-x: auto;
            margin-top: 8px;
        }

        table {
            width: 100%;
            min-width: 900px;
            border-collapse: collapse;
            background: var(--bg-card);
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 4px 12px rgba(0,0,0,0.35);
            color: var(--text-main);
        }

        thead tr {
            background: var(--bg-table-head);
        }

        th,
        td {
            padding: 9px 11px;
            font-size: 13px;
            border-bottom: 1px solid rgba(255,255,255,0.12);
            white-space: nowrap;
        }

        body[data-theme="light"] th,
        body[data-theme="light"] td {
            border-bottom-color: rgba(0,0,0,0.06);
        }

        th {
            color: var(--text-heading);
            font-weight: 600;
            text-align: center;
        }

        td {
            text-align: center;
        }

        /* left align product name */
        td.product-cell {
            text-align: left;
        }

        /* numeric columns right aligned */
        td.numeric {
            text-align: right;
        }

        tbody tr {
            background: var(--bg-table-row);
        }

        tbody tr:nth-child(even) {
            background: var(--bg-table-row);
            opacity: 0.96;
        }

        tbody tr:hover {
            background: var(--bg-table-hover);
        }

        footer {
            background: transparent;
        }
    </style>
</head>

<body>

<?php include("sidebar.php"); ?>

<div class="content-area">

    <div class="page-header">
        <div class="page-title">Top and Bottom Performing Products</div>
        <div class="page-subtitle">Fast-moving and slow-moving items by quantity sold and revenue.</div>
    </div>

    <div class="cards-wrapper">

        <!-- TOP 5 FAST-MOVING -->
        <div class="card-box">
            <div class="card-title">Top 5 Fast-Moving Products</div>

            <div class="table-wrapper">
                <table>
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Product Name</th>
                            <th>Quantity Sold</th>
                            <th>Total Revenue (KES)</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $i = 1; while ($row = $topProductsQuery->fetch_assoc()): ?>
                        <tr>
                            <td><?= $i++ ?></td>
                            <td class="product-cell"><?= htmlspecialchars($row['name']) ?></td>
                            <td class="numeric"><?= number_format($row['total_sold']) ?></td>
                            <td class="numeric"><?= number_format($row['total_revenue'], 2) ?></td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- BOTTOM 5 SLOW-MOVING -->
        <div class="card-box">
            <div class="card-title">Bottom 5 Slow-Moving Products</div>

            <div class="table-wrapper">
                <table>
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Product Name</th>
                            <th>Quantity Sold</th>
                            <th>Total Revenue (KES)</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $i = 1; while ($row = $bottomProductsQuery->fetch_assoc()): ?>
                        <tr>
                            <td><?= $i++ ?></td>
                            <td class="product-cell"><?= htmlspecialchars($row['name']) ?></td>
                            <td class="numeric"><?= number_format($row['total_sold']) ?></td>
                            <td class="numeric"><?= number_format($row['total_revenue'], 2) ?></td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>

    </div>

</div>

<?php include('footer.php'); ?>

</body>
</html>
