<?php
if (!isset($page_title)) { $page_title = "POS System"; }
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?></title>

    <!-- Google Font -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <style>
        /* ----------------------------------
           COLOR PALETTE
           Default = DARK THEME
        -----------------------------------*/
        :root {
            --bg-main: #001f3f;
            --bg-sidebar: #001731;
            --bg-card: #012a57;
            --bg-table-head: #01356f;
            --bg-table-row: #01356f;
            --bg-table-hover: #014b94;
            --accent-gold: #f4b400;
            --accent-gold-soft: #ffcc00;
            --text-main: #e6e6e6;
            --text-heading: #ffffff;
        }

        /* ----------------------------------
           LIGHT THEME (ADMIN)
           Apply with: <body data-theme="light">
        -----------------------------------*/
        body[data-theme="light"] {
            --bg-main: #f3f4f6;          /* page background */
            --bg-sidebar: #ffffff;       /* sidebar background */
            --bg-card: #ffffff;          /* cards / content */
            --bg-table-head: #e5e7eb;
            --bg-table-row: #ffffff;
            --bg-table-hover: #e0f2fe;
            --accent-gold: #d4a017;
            --accent-gold-soft: #facc15;
            --text-main: #111827;
            --text-heading: #111827;
        }

        /* ----------------------------------
           GLOBAL STYLING
        -----------------------------------*/
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Poppins', sans-serif;
        }

        html, body {
            background-color: var(--bg-main);
            color: var(--text-main);
            min-height: 100vh;
        }

        body {
            display: flex;
            flex-direction: column;
        }

        h1, h2, h3, h4, h5 {
            color: var(--text-heading);
        }

        .wrapper {
            display: flex;
            flex: 1;
            width: 100%;
        }

        /* ----------------------------------
           SIDEBAR
        -----------------------------------*/
        /* SIDEBAR ---------------------------------------------------*/
/* ========== SIDEBAR BASE ========== */
/* ========== SIDEBAR ========== */
.sidebar {
    font-family: 'Poppins', sans-serif;
    width: 250px;
    background: linear-gradient(
        180deg,
        var(--bg-sidebar, #020617) 0%,
        #021d53 40%,
        #000814 100%
    );
    height: 100vh;
    position: fixed;
    left: 0;
    top: 0;
    padding: 18px 14px 20px;
    overflow-y: auto;
    transition: width 0.25s ease, box-shadow 0.25s ease;
    box-shadow: 4px 0 18px rgba(0, 0, 0, 0.55);
    border-right: 1px solid rgba(148,163,184,0.45);
    display: flex;
    flex-direction: column;
    z-index: 999;
}

/* collapsed state */
.sidebar.collapsed {
    width: 78px;
}

/* ========== HEADER / BRAND ========== */
.sidebar-header {
    display: flex;
    align-items: center;
    gap: 10px;
    padding: 0 6px 14px;
    border-bottom: 1px solid rgba(148,163,184,0.35);
}

.sidebar-logo {
    width: 34px;
    height: 34px;
    border-radius: 999px;
    background: radial-gradient(circle at 30% 20%, #facc15, #b45309);
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 700;
    font-size: 16px;
    color: #0b1020;
    box-shadow: 0 0 0 3px rgba(248, 250, 109, 0.35);
}

.sidebar-title-main {
    font-size: 15px;
    font-weight: 600;
    color: #e5e7eb;
    transition: opacity 0.2s ease, transform 0.2s ease; /* NEW */
}

.sidebar-title-sub {
    font-size: 11px;
    text-transform: uppercase;
    letter-spacing: 0.14em;
    color: rgba(148,163,184,0.9);
    transition: opacity 0.2s ease, transform 0.2s ease; /* NEW */
}

.sidebar.collapsed .sidebar-header {
    justify-content: center;
}

.sidebar.collapsed .sidebar-title-main,
.sidebar.collapsed .sidebar-title-sub {
    opacity: 0;                    /* NEW */
    transform: translateX(-8px);   /* NEW */
    pointer-events: none;          /* NEW */
    display: none;
}

/* ========== MENU ========== */
.sidebar-menu {
    margin-top: 16px;
    padding: 0;
    list-style: none;
    flex: 1; /* pushes logout to bottom */
}

.sidebar-link {
    display: flex;
    align-items: center;
    gap: 10px;
    padding: 9px 12px;
    margin: 4px 2px;
    border-radius: 9px;
    color: #e5e7eb;
    text-decoration: none;
    font-size: 14px;
    line-height: 1.2;
    position: relative;
    transition:
        background 0.2s ease,
        color 0.2s ease,
        transform 0.15s ease,
        box-shadow 0.2s ease;
}

.sidebar-icon {
    width: 22px;
    height: 22px;
    border-radius: 999px;
    background: rgba(15,23,42,0.6);
    display: inline-flex;
    align-items: center;
    justify-content: center;
    font-size: 14px;
}

/* long names: wrap nicely instead of disappearing */
.sidebar-text {
    flex: 1;
    white-space: normal;
    word-wrap: break-word;
    transition: opacity 0.2s ease, transform 0.2s ease; /* NEW */
}

/* hover / active state */
.sidebar-link:hover {
    background: radial-gradient(circle at top left, rgba(56,189,248,0.18), transparent 60%);
    color: #f9fafb;
    box-shadow: 0 4px 14px rgba(15,23,42,0.9);
    transform: translateX(4px);
}

.sidebar-link.active {
    background: linear-gradient(90deg, rgba(59,130,246,0.9), rgba(56,189,248,0.95));
    color: #0b1020;
    box-shadow: 0 4px 18px rgba(37,99,235,0.75);
}

.sidebar-link.active .sidebar-icon {
    background: rgba(15,23,42,0.05);
}

/* collapsed: icons stay centered, text hidden cleanly */
.sidebar.collapsed .sidebar-link {
    justify-content: center;
    padding-inline: 10px;
}

.sidebar.collapsed .sidebar-text {
    opacity: 0;                    /* NEW */
    transform: translateX(-8px);   /* NEW */
    pointer-events: none;          /* NEW */
    display: none;
}

/* ========== FOOTER / LOGOUT ========== */
.sidebar-footer {
    margin-top: 10px;
    padding-top: 10px;
    border-top: 1px solid rgba(15,23,42,0.6);
}

.sidebar-logout {
    color: #fecaca;
}

.sidebar-logout .sidebar-icon {
    background: rgba(127,29,29,0.85);
}

.sidebar-logout:hover {
    background: radial-gradient(circle at top left, rgba(248,113,113,0.38), transparent 60%);
    color: #fee2e2;
}

/* ========== MAIN CONTENT SHIFT (IMPORTANT) ========== */
.main-content {
    margin-left: 250px;                 /* expanded width */
    transition: margin-left 0.25s ease; /* smooth shift */
}

/* if sidebar comes immediately before .main-content in HTML */
.sidebar.collapsed + .main-content {
    margin-left: 78px;                  /* collapsed width */
}

/* ========== LIGHT THEME OVERRIDE ========== */
body[data-theme="light"] .sidebar {
    background: linear-gradient(
        180deg,
        #fefce8 0%,
        #fef3c7 40%,
        #f9fafb 100%
    );
    border-right: 1px solid rgba(180,83,9,0.6);
    box-shadow: 4px 0 16px rgba(15,23,42,0.25);
}

body[data-theme="light"] .sidebar-title-main {
    color: #b45309;
}

body[data-theme="light"] .sidebar-title-sub {
    color: #6b7280;
}

body[data-theme="light"] .sidebar-link {
    color: #111827;
}

body[data-theme="light"] .sidebar-link:hover {
    background: rgba(254,243,199,0.95);
    color: #b45309;
    box-shadow: 0 3px 10px rgba(180,83,9,0.35);
}

body[data-theme="light"] .sidebar-link.active {
    background: linear-gradient(90deg, #fbbf24, #f59e0b);
    color: #111827;
    box-shadow: 0 4px 14px rgba(180,83,9,0.5);
}

body[data-theme="light"] .sidebar-icon {
    background: rgba(243,244,246,0.95);
}

body[data-theme="light"] .sidebar-logout {
    color: #b91c1c;
}
body[data-theme="light"] .sidebar-logout:hover {
    background: rgba(254,226,226,0.95);
}


        /* ----------------------------------
           MAIN CONTENT AREA
        -----------------------------------*/
        .main-content {
            margin-left: 250px;
            flex: 1;
            transition: 0.3s ease;
            padding: 25px;
            background: var(--bg-main);
        }

        .main-content.collapsed {
            margin-left: 70px;
        }

        /* ----------------------------------
           TOP BAR
        -----------------------------------*/
        .topbar {
            background: var(--bg-sidebar);
            padding: 18px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-bottom: 2px solid #B8860B;
            position: sticky;
            top: 0;
            z-index: 10;
        }

        .menu-btn {
            font-size: 26px;
            cursor: pointer;
            color: var(--accent-gold);
            transition: 0.3s;
        }

        .menu-btn:hover {
            color: #e6c34b;
        }

        /* ----------------------------------
           CARDS / PAGE SECTIONS
        -----------------------------------*/
        .container-box,
        .page-card,
        .card {
            background: var(--bg-card);
            padding: 25px;
            border-radius: 14px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.28);
            border: none;
            color: var(--text-main);
        }

        .cards-container {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
            margin-top: 25px;
        }

        .card {
            flex: 1 1 260px;
            border-left: 6px solid #D4AF37;
            transition: 0.3s ease;
        }

        .card h3 {
            color: var(--accent-gold);
            margin-bottom: 10px;
        }

        .card:hover {
            background: var(--bg-table-hover);
            transform: translateY(-5px);
            box-shadow: 0 5px 18px rgba(0,0,0,0.4);
        }

        /* ----------------------------------
           TABLE STYLING
           Use class="table-theme" on your tables
        -----------------------------------*/
        .table-theme {
            width: 100%;
            border-collapse: collapse;
            background-color: var(--bg-card);
            color: var(--text-main);
        }

        .table-theme thead {
            background: var(--bg-table-head);
            color: #ffffff;
        }

        body[data-theme="light"] .table-theme thead {
            color: #111827;
        }

        .table-theme th,
        .table-theme td {
            padding: 10px 14px;
            border: 1px solid rgba(0,0,0,0.12);
            white-space: nowrap;
        }

        body:not([data-theme="light"]) .table-theme th,
        body:not([data-theme="light"]) .table-theme td {
            border-color: rgba(255,255,255,0.15);
        }

        .table-theme tbody tr {
            background-color: var(--bg-table-row);
            color: var(--text-main);
        }

        .table-theme tbody tr:nth-of-type(odd),
        .table-theme tbody tr:nth-of-type(even) {
            background-color: var(--bg-table-row);
        }

        .table-theme tbody tr:hover {
            background: var(--bg-table-hover);
            color: #ffffff;
        }

        body[data-theme="light"] .table-theme tbody tr:hover {
            color: #111827;
        }

        /* ----------------------------------
           BUTTONS
        -----------------------------------*/
        .btn,
        .btn-primary,
        .btn-success,
        .btn-warning {
            background: var(--accent-gold);
            border: none;
            color: var(--bg-main);
            font-weight: 600;
            padding: 6px 14px;
            border-radius: 4px;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
            font-size: 13px;
        }

        .btn:hover,
        .btn-primary:hover,
        .btn-success:hover,
        .btn-warning:hover {
            background: var(--accent-gold-soft);
        }

        /* ----------------------------------
           FORMS
        -----------------------------------*/
        .form-control {
            background: var(--bg-table-head);
            border: 1px solid #0a4a85;
            color: #ffffff;
            padding: 8px 10px;
            border-radius: 4px;
        }

        body[data-theme="light"] .form-control {
            color: #111827;
            border-color: #cbd5f5;
        }

        .form-control:focus {
            background: var(--bg-table-hover);
            border-color: var(--accent-gold);
            color: #ffffff;
            outline: none;
        }

        body[data-theme="light"] .form-control:focus {
            color: #111827;
        }

        label {
            color: var(--text-main);
        }

        /* ----------------------------------
           FOOTER
        -----------------------------------*/
        footer,
        footer.footer {
            background: transparent !important;
            color: #D4AF37 !important;
            border-top: 2px solid #B8860B !important;
        }
    </style>

    <script>
    // Apply saved admin theme to EVERY page that includes head.php
    (function () {
        const saved = localStorage.getItem('adminTheme');
        const theme = (saved === 'light' || saved === 'dark') ? saved : 'dark';

        function applyTheme() {
            if (document.body) {
                document.body.setAttribute('data-theme', theme);
            }
        }

        if (document.readyState === 'loading') {
            document.addEventListener('DOMContentLoaded', applyTheme);
        } else {
            applyTheme();
        }
    })();

    // Global toggle so any page can use onclick="toggleAdminTheme()"
    function toggleAdminTheme() {
        const current = document.body.getAttribute('data-theme') || 'dark';
        const next = current === 'dark' ? 'light' : 'dark';
        document.body.setAttribute('data-theme', next);
        localStorage.setItem('adminTheme', next);
    }
    </script>
</head>
