<?php
session_start();
if (!isset($_SESSION['username']) || $_SESSION['role'] !== 'admin') {
    header("Location: login.html");
    exit();
}

include 'db_connect.php';

if (!isset($_GET['id'])) {
    header("Location: manage_products.php");
    exit();
}

$id = intval($_GET['id']);
$message = "";

/* -----------------------------
   UPDATE PRODUCT (No Qty Edit)
------------------------------ */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $name = trim($_POST['name']);
    $category = trim($_POST['category']);
    $selling_price = floatval($_POST['selling_price']);

    $stmt = $conn->prepare("UPDATE products SET name=?, category=?, selling_price=? WHERE id=?");
    $stmt->bind_param("ssdi", $name, $category, $selling_price, $id);

    if ($stmt->execute()) {
        header("Location: manage_products.php?success=Product updated successfully");
        exit();
    } else {
        $message = "❌ Error updating product.";
    }
}

/* -----------------------------
   FETCH PRODUCT DETAILS
------------------------------ */
$stmt = $conn->prepare("SELECT * FROM products WHERE id=?");
$stmt->bind_param("i", $id);
$stmt->execute();
$product = $stmt->get_result()->fetch_assoc();

if (!$product) {
    header("Location: manage_products.php");
    exit();
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Edit Product</title>
    <?php include('head.php'); ?>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap');
        body {
            font-family: 'Poppins', sans-serif;
            background: #001f3f
            margin: 0;
            padding: 25px;

        }
        h2 {
            text-align: center;
            margin-bottom: 20px;
            color: gold;
            font-weight: 600;
        }
        .container {
            width: 420px;
            margin: auto;
            color: black;
            background: white;
            padding: 25px;
            border-radius: 10px;
            box-shadow: 0px 6px 20px rgba(0,0,0,0.1);
        }
        label {
            margin-top: 12px;
            display: block;
            font-weight: 500;
        }
        input {
            width: 100%;
            padding: 11px;
            margin-top: 5px;
            border-radius: 6px;
            border: 1px solid #ccc;
            font-size: 14px;
        }
        input[readonly] {
            background: #eef2f7;
            cursor: not-allowed;
        }
        button {
            width: 100%;
            padding: 13px;
            border: none;
            margin-top: 18px;
            background: #3498db;
            color: white;
            font-size: 15px;
            border-radius: 6px;
            cursor: pointer;
            font-weight: 600;
        }
        button:hover {
            background: #2d78b1;
        }
        .message {
            text-align: center;
            color: #c0392b;
            font-weight: 500;
            margin-bottom: 12px;
        }
        .links {
            text-align: center;
            margin-top: 20px;
        }
        .links a {
            margin: 5px;
            display: inline-block;
            padding: 10px 15px;
            background: #2d4059;
            color: white;
            border-radius: 6px;
            text-decoration: none;
            font-size: 13px;
        }
        .links a:hover {
            background: #1b2a3b;
        }
    </style>
</head>

<body>

<h2>Edit Product</h2>
<?php include("sidebar.php"); ?>
<div class="container">

    <?php if ($message): ?>
        <div class="message"><?= $message ?></div>
    <?php endif; ?>

    <form method="POST">

        <label>Product Name</label>
        <input type="text" name="name" value="<?= htmlspecialchars($product['name']) ?>" required>

        <label>Category</label>
        <input type="text" name="category" value="<?= htmlspecialchars($product['category']) ?>" required>

        <label>Average Buying Price (Weighted)</label>
        <input type="number" value="<?= $product['buying_price'] ?>" readonly>

        <label>Default Selling Price</label>
        <input type="number" step="0.01" name="selling_price" value="<?= $product['selling_price'] ?>" required>

        <label>Stock Available</label>
        <input type="number" value="<?= $product['quantity'] ?>" readonly>

        <label>Total Stock Value (Buying Price × Qty)</label>
        <input type="text" value="KES <?= number_format($product['buying_price'] * $product['quantity'], 2) ?>" readonly>

        <button type="submit">Update Product</button>
    </form>

</div>

<div class="links">
    <a href="manage_products.php">← Back to Products</a>
    <a href="admin_dashboard.php">Dashboard</a>
    <a href="batch_list.php">Stock Batches</a>
</div>

<?php include 'footer.php'; ?>
</body>
</html>
