<?php
session_start();
if (!isset($_SESSION['username']) || $_SESSION['role'] !== 'cashier') {
    header("Location: login.php");
    exit();
}

include("db_connect.php");

// Notifications
$success = "";
$error   = "";

if (isset($_GET['added']))   $success = "Customer added successfully!";
if (isset($_GET['updated'])) $success = "Customer updated successfully!";
if (isset($_GET['deleted'])) $success = "Customer deleted successfully!";
if (isset($_GET['error']))   $error   = "Please fill in all fields.";

// Pagination settings
$limit  = 10; // 10 entries per page
$page   = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$offset = ($page - 1) * $limit;

// Get total number of customers
$total_result  = $conn->query("SELECT COUNT(*) AS total FROM customers");
$total_row     = $total_result->fetch_assoc();
$total_records = (int)($total_row['total'] ?? 0);
$total_pages   = max(1, (int)ceil($total_records / $limit));

// Fetch customers for current page
$customers = $conn->query("
    SELECT *
    FROM customers
    ORDER BY id DESC
    LIMIT $limit OFFSET $offset
");

$page_title = "Customers | Cashier POS";
$active     = 'customers'; // for top-nav highlight
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <?php include 'cashier_head.php'; ?>
    <style>
        /* Layout & footer support */
        html, body {
            height: 100%;
        }
        body {
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }
        .cashier-shell {
            flex: 1;
            display: flex;
        }

        .cashier-main {
            padding: 24px 30px 34px;
        }

        @media (max-width: 900px) {
            .cashier-main {
                padding: 18px 16px 26px;
            }
        }

        /* Cards */

        .pos-card,
        .pos-table-card {
            background: linear-gradient(135deg, #064ab8 0%, #022a6b 55%, #021d53 100%);
            border-radius: 18px;
            padding: 18px 22px 22px;
            box-shadow: 0 20px 45px rgba(0,0,0,0.55);
            color: #E9F5FF;
            border: 1px solid rgba(130,238,253,0.5);
            margin-bottom: 22px;
        }

        html[data-theme="light"] .pos-card,
        html[data-theme="light"] .pos-table-card {
            background: #ffffff;
            border-color: rgba(148,163,184,0.55);
            color: #0f172a;
            box-shadow: 0 12px 26px rgba(15,23,42,0.12);
        }

        .pos-card-header h2 {
            font-size: 19px;
            font-weight: 600;
        }

        .pos-card-header p {
            font-size: 13px;
            color: #c3d8ff;
            margin-top: 4px;
        }

        html[data-theme="light"] .pos-card-header p {
            color: #4b5563;
        }

        .customer-form {
            margin-top: 14px;
            max-width: 520px;
        }

        .customer-form label {
            display: block;
            font-size: 13px;
            font-weight: 500;
            margin-bottom: 4px;
            color: #E9F5FF;
        }

        html[data-theme="light"] .customer-form label {
            color: #0f172a;
        }

        .customer-form input[type="text"] {
            width: 100%;
            padding: 9px 11px;
            border-radius: 10px;
            border: 1px solid rgba(130,238,253,0.5);
            background: #0a3d87;
            color: #E9F5FF;
            font-size: 13px;
            margin-bottom: 10px;
        }

        .customer-form input::placeholder {
            color: rgba(226,232,240,0.7);
        }

        .customer-form input:focus {
            outline: none;
            border-color: #00FFE5;
            box-shadow: 0 0 0 1px rgba(0,255,229,0.35);
        }

        html[data-theme="light"] .customer-form input[type="text"] {
            background: #ffffff;
            border-color: rgba(148,163,184,0.55);
            color: #0f172a;
        }

        html[data-theme="light"] .customer-form input::placeholder {
            color: #9ca3af;
        }

        .btn-primary {
            padding: 10px 18px;
            border-radius: 999px;
            border: none;
            cursor: pointer;
            font-size: 14px;
            font-weight: 600;
            background: var(--cash-accent-turquoise);
            color: #011b35;
            margin-top: 4px;
        }

        .btn-primary:hover {
            filter: brightness(1.08);
        }

        .alert {
            margin-bottom: 10px;
            padding: 8px 10px;
            border-radius: 10px;
            font-size: 13px;
            border-left-width: 4px;
            border-left-style: solid;
        }

        .alert-success {
            background: rgba(34,197,94,0.12);
            border-left-color: rgba(34,197,94,0.9);
            color: #bbf7d0;
        }

        .alert-error {
            background: rgba(239,68,68,0.14);
            border-left-color: rgba(248,113,113,0.95);
            color: #fecaca;
        }

        html[data-theme="light"] .alert-success {
            background: #dcfce7;
            border-left-color: #16a34a;
            color: #166534;
        }

        html[data-theme="light"] .alert-error {
            background: #fee2e2;
            border-left-color: #ef4444;
            color: #b91c1c;
        }

        /* Table */

        .pos-table-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            gap: 14px;
            margin-bottom: 10px;
            flex-wrap: wrap;
        }

        .pos-table-header h3 {
            font-size: 17px;
            font-weight: 600;
        }

        .pos-table-header p {
            font-size: 12px;
            color: #c3d8ff;
            margin-top: 2px;
        }

        html[data-theme="light"] .pos-table-header p {
            color: #4b5563;
        }

        .pos-table-wrapper {
            width: 100%;
            overflow-x: auto;
            margin-top: 6px;
        }

        table.pos-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 13px;
            min-width: 750px;
        }

        .pos-table th,
        .pos-table td {
            padding: 9px 8px;
            text-align: center;
            border-bottom: 1px solid rgba(148,163,184,0.25);
            color: #F9FAFF; /* dark theme text */
        }

        .pos-table th {
            background: #012a73;
            position: sticky;
            top: 0;
            z-index: 1;
            font-weight: 600;
        }

        .pos-table tbody tr:nth-child(even) { background: rgba(2,35,98,0.82); }
        .pos-table tbody tr:nth-child(odd)  { background: rgba(1,26,80,0.82); }

        .pos-table tbody tr:hover { background: rgba(130,238,253,0.16); }

        .cell-left { text-align: left; }

        .empty-row {
            padding: 18px;
            color: #c3d8ff;
            text-align: center;
        }

        /* 🔆 Light theme overrides for table text & rows */
        html[data-theme="light"] .pos-table th,
        html[data-theme="light"] .pos-table td {
            color: #0f172a;
            border-bottom-color: rgba(148,163,184,0.35);
        }

        html[data-theme="light"] .pos-table th {
            background: #e5f3ff;
        }

        html[data-theme="light"] .pos-table tbody tr:nth-child(even),
        html[data-theme="light"] .pos-table tbody tr:nth-child(odd) {
            background: #f9fafb;
        }

        .badge-muted {
            font-size: 11px;
            padding: 4px 9px;
            border-radius: 999px;
            background: rgba(15,23,42,0.86);
            color: #c3d8ff;
        }

        html[data-theme="light"] .badge-muted {
            background: #e5f3ff;
            color: #0f172a;
        }

        .action-pill {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            padding: 5px 10px;
            font-size: 12px;
            border-radius: 999px;
            text-decoration: none;
            border: 1px solid transparent;
            margin: 0 2px;
        }

        .action-edit {
            background: rgba(59,130,246,0.16);
            border-color: rgba(59,130,246,0.7);
            color: #bfdbfe;
        }

        .action-edit:hover {
            background: rgba(59,130,246,0.3);
        }

        .action-delete {
            background: rgba(239,68,68,0.16);
            border-color: rgba(239,68,68,0.8);
            color: #fecaca;
        }

        .action-delete:hover {
            background: rgba(239,68,68,0.3);
        }

        html[data-theme="light"] .action-edit {
            background: #dbeafe;
            border-color: #60a5fa;
            color: #1d4ed8;
        }
        html[data-theme="light"] .action-delete {
            background: #fee2e2;
            border-color: #f87171;
            color: #b91c1c;
        }

        .pagination {
            margin-top: 14px;
            display: flex;
            flex-wrap: wrap;
            gap: 8px;
            justify-content: center;
        }

        .page-btn {
            padding: 7px 12px;
            border-radius: 999px;
            border: 1px solid rgba(130,238,253,0.7);
            background: rgba(0,26,80,0.4);
            color: #E9F5FF;
            text-decoration: none;
            font-size: 12px;
            font-weight: 500;
        }

        .page-btn:hover {
            background: rgba(15,23,42,0.96);
        }

        .page-btn.active {
            background: var(--cash-accent-turquoise);
            border-color: var(--cash-accent-turquoise);
            color: #011b35;
            font-weight: 700;
        }

        html[data-theme="light"] .page-btn {
            background: #eff6ff;
            border-color: rgba(148,163,184,0.7);
            color: #0f172a;
        }
        html[data-theme="light"] .page-btn.active {
            background: #0ea5e9;
            color: #f9fafb;
        }

        .back-link {
            text-decoration: none;
            font-size: 13px;
            color: #82EEFD;
        }

        .back-link:hover {
            text-decoration: underline;
        }

        html[data-theme="light"] .back-link {
            color: #0369a1;
        }

        /* Footer pinned bottom */
        footer {
            background: transparent;
            text-align: center;
            font-size: 12px;
            color: var(--cash-text-muted);
            padding: 10px 18px;
            margin-top: auto;
        }
    </style>
</head>
<body>

<div class="cashier-shell">
    <?php include "cashier_sidebar.php"; ?>

    <main class="cashier-main">

        <!-- Topbar with nav + theme toggle (consistent with dashboard) -->
        <div class="cashier-topbar">
            <div class="cashier-topbar-left">
                <h1><?= htmlspecialchars($page_title) ?></h1>
                <small>Add new customers and manage saved records.</small>
            </div>

            <div class="cashier-topbar-right">
                <nav class="cashier-topnav">
                    <a href="cashier_dashboard.php" class="<?= ($active === 'dashboard') ? 'active' : '' ?>">Dashboard</a>
                    <a href="record_sales.php" class="<?= ($active === 'sales') ? 'active' : '' ?>">Sales</a>
                    <a href="cashier_view_daily_sales.php" class="<?= ($active === 'daily_sales') ? 'active' : '' ?>">Today’s Sales</a>
                    <a href="transaction_history.php" class="<?= ($active === 'transactions') ? 'active' : '' ?>">Transactions</a>
                    <a href="customers.php" class="<?= ($active === 'customers') ? 'active' : '' ?>">Customers</a>
                </nav>

                <button type="button" class="cashier-theme-toggle" onclick="toggleCashierTheme()">
                    <span class="icon">🌓</span>
                    <span class="label">Theme</span>
                </button>

                <button class="cashier-toggle" onclick="toggleCashierSidebar()">☰</button>
            </div>
        </div>

        <!-- Add / edit block -->
        <section class="pos-card">
            <div class="pos-card-header">
                <h2>Customer information</h2>
                <p>Store customer names and phone numbers for debts, loyalty, or quick lookup.</p>
            </div>

            <?php if ($success): ?>
                <div class="alert alert-success">
                    <?= htmlspecialchars($success) ?>
                </div>
            <?php endif; ?>

            <?php if ($error): ?>
                <div class="alert alert-error">
                    <?= htmlspecialchars($error) ?>
                </div>
            <?php endif; ?>

            <form method="POST" action="save_customer.php" class="customer-form">
                <label for="customer_name">Customer name</label>
                <input
                    type="text"
                    id="customer_name"
                    name="customer_name"
                    placeholder="e.g. John Doe"
                    required
                >

                <label for="phone">Phone number</label>
                <input
                    type="text"
                    id="phone"
                    name="phone"
                    placeholder="e.g. 07xx xxx xxx"
                    required
                >

                <button type="submit" class="btn-primary">Save customer</button>
            </form>
        </section>

        <!-- Customers table -->
        <section class="pos-table-card">
            <div class="pos-table-header">
                <div>
                    <h3>Saved customers</h3>
                    <p>Showing <?= $total_records ? "page $page of $total_pages" : "no customers yet." ?></p>
                </div>
                <span class="badge-muted">
                    Total customers: <?= number_format($total_records) ?>
                </span>
            </div>

            <div class="pos-table-wrapper">
                <table class="pos-table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Customer name</th>
                            <th>Phone</th>
                            <th>Date added</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if($customers && $customers->num_rows > 0): ?>
                            <?php while ($row = $customers->fetch_assoc()): ?>
                                <tr>
                                    <td><?= (int)$row['id'] ?></td>
                                    <td class="cell-left"><?= htmlspecialchars($row['customer_name']) ?></td>
                                    <td><?= htmlspecialchars($row['phone']) ?></td>
                                    <td>
                                        <?= htmlspecialchars(
                                            date(
                                                'Y-m-d H:i',
                                                strtotime($row['created_at'] ?? 'now')
                                            )
                                        ) ?>
                                    </td>
                                    <td>
                                        <a href="edit_customer.php?id=<?= (int)$row['id'] ?>"
                                           class="action-pill action-edit">Edit</a>
                                        <a href="delete_customer.php?id=<?= (int)$row['id'] ?>"
                                           onclick="return confirm('Are you sure you want to delete this customer?');"
                                           class="action-pill action-delete">Delete</a>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="5" class="empty-row">No customers found.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <?php if ($total_pages > 1): ?>
                <div class="pagination">
                    <?php for($i = 1; $i <= $total_pages; $i++): ?>
                        <a href="?page=<?= $i ?>"
                           class="page-btn <?= ($i == $page) ? 'active' : '' ?>">
                            <?= $i ?>
                        </a>
                    <?php endfor; ?>
                </div>
            <?php endif; ?>

            <div style="margin-top: 14px;">
                <a href="cashier_dashboard.php" class="back-link">← Back to dashboard</a>
            </div>
        </section>

    </main>
</div>


<script>
function toggleCashierSidebar() {
    const sidebar = document.getElementById('cashierSidebar');
    if (sidebar) {
        sidebar.classList.toggle('is-collapsed');
    }
}
</script>

</body>
</html>
