<?php
session_start();
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit();
}

require 'db_connect.php';

// Fetch products with low stock (less than 10)
$lowStockQuery = $conn->query("
    SELECT id, name, quantity 
    FROM products 
    WHERE quantity < 10
    ORDER BY quantity ASC
");

// Title for head.php if you use it
$page_title = "Low Stock Alerts";
?>
<!DOCTYPE html>
<html>
<head>
    <title><?= htmlspecialchars($page_title) ?></title>
    <?php include("head.php"); ?>

    <style>
        body {
            font-family: 'Poppins', Arial, sans-serif;
            background: var(--bg-main);
            margin: 0;
            color: var(--text-main);
        }

        /* Shift content to the right of sidebar */
        .content-area {
            margin-left: 260px;
            padding: 25px 30px;
            background: var(--bg-main);
        }
        @media (max-width: 768px) {
            .content-area {
                margin-left: 80px;
                padding: 20px;
            }
        }

        .page-header {
            display: block;
            text-align: center;
            margin-bottom: 18px;
        }

        .page-title {
            font-size: 22px;
            font-weight: 600;
            color: #ff6b6b; /* keep red to emphasize alert */
            margin-bottom: 4px;
        }

        .page-subtitle {
            font-size: 13px;
            color: var(--accent-gold);
        }

        .card-box {
            width: 100%;
            max-width: 1100px;
            margin: 0 auto;
            background: var(--bg-card);
            padding: 20px 22px;
            border-radius: 14px;
            box-shadow: 0 4px 14px rgba(0,0,0,0.35);
            border: 1px solid #0a4a85;
            color: var(--text-main);
        }

        body[data-theme="light"] .card-box {
            border-color: rgba(148,163,184,0.6);
            box-shadow: 0 10px 24px rgba(15,23,42,0.08);
        }

        .card-title {
            font-size: 16px;
            font-weight: 500;
            color: var(--text-heading);
            margin-bottom: 10px;
        }

        /* Alerts */
        .alert {
            padding: 10px 12px;
            border-radius: 6px;
            margin-bottom: 12px;
            font-size: 13px;
        }
        .alert-success-custom {
            background: rgba(34,197,94,0.15);
            border-left: 5px solid #22c55e;
            color: #bbf7d0;
        }
        .alert-warning-custom {
            background: rgba(234,179,8,0.15);
            border-left: 5px solid #eab308;
            color: #fef9c3;
        }
        body[data-theme="light"] .alert-success-custom {
            background: #dcfce7;
            color: #166534;
        }
        body[data-theme="light"] .alert-warning-custom {
            background: #fef9c3;
            color: #854d0e;
        }

        /* Table wrapper */
        .table-wrapper {
            width: 100%;
            overflow-x: auto;
            margin-top: 8px;
        }

        table {
            width: 100%;
            min-width: 800px;
            border-collapse: collapse;
            background: var(--bg-card);
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 4px 12px rgba(0,0,0,0.35);
            color: var(--text-main);
        }

        thead tr {
            background: var(--bg-table-head);
        }

        th,
        td {
            padding: 9px 10px;
            font-size: 13px;
            border-bottom: 1px solid rgba(255,255,255,0.12);
            white-space: nowrap;
        }

        body[data-theme="light"] th,
        body[data-theme="light"] td {
            border-bottom-color: rgba(0,0,0,0.06);
        }

        th {
            color: var(--text-heading);
            font-weight: 600;
            text-align: center;
        }

        td {
            text-align: center;
        }

        /* left align product name */
        td.product-cell {
            text-align: left;
        }

        tbody tr {
            background: var(--bg-table-row);
        }

        tbody tr:nth-child(even) {
            background: var(--bg-table-row);
            opacity: 0.97;
        }

        tbody tr:hover {
            background: var(--bg-table-hover);
        }

        .numeric {
            text-align: right;
        }

        /* Custom status badges overriding bootstrap ones if loaded */
        .badge {
            display: inline-block;
            padding: 4px 10px;
            border-radius: 999px;
            font-size: 11px;
            font-weight: 600;
        }

        .badge-out {
            background: #e74c3c;
            color: #ffffff;
        }

        .badge-very-low {
            background: #ffc107;
            color: #001f3f;
        }

        .badge-low {
            background: #17a2b8;
            color: #001f3f;
        }

        footer {
            background: transparent !important;
        }
    </style>
</head>
<body>

<?php include("sidebar.php"); ?>

<div class="content-area">

    <div class="page-header">
        <div>
            <div class="page-title">⚠ Low Stock Alert (Below 10)</div>
            <div class="page-subtitle">Monitor items that require restocking.</div>
        </div>
    </div>

    <div class="card-box">
        <div class="card-title">Stock Status</div>

        <?php if ($lowStockQuery->num_rows == 0): ?>
            <div class="alert alert-success-custom">
                All products have sufficient stock (10 units or more).
            </div>
        <?php else: ?>
            <div class="alert alert-warning-custom">
                Some products are close to running out. Consider restocking them soon.
            </div>

            <div class="table-wrapper">
                <table>
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Product Name</th>
                            <th>Quantity Left</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $i = 1; 
                        while ($row = $lowStockQuery->fetch_assoc()): 
                        ?>
                        <tr>
                            <td><?= $i++ ?></td>
                            <td class="product-cell"><?= htmlspecialchars($row['name']) ?></td>
                            <td class="numeric"><?= $row['quantity'] ?></td>
                            <td>
                                <?php if ($row['quantity'] == 0): ?>
                                    <span class="badge badge-out">Out of Stock</span>
                                <?php elseif ($row['quantity'] < 5): ?>
                                    <span class="badge badge-very-low">Very Low</span>
                                <?php else: ?>
                                    <span class="badge badge-low">Low</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>

        <?php endif; ?>

    </div>

</div>

<?php include("footer.php"); ?>

</body>
</html>
