<?php
session_start();
if (!isset($_SESSION['username']) || $_SESSION['role'] !== 'admin') {
    header("Location: login.html?error=unauthorized");
    exit();
}

include("db_connect.php");

date_default_timezone_set('Africa/Nairobi');
$today = date('Y-m-d');

// Fetch sales for today
$query = "
    SELECT s.*, p.name AS product_name 
    FROM sales s
    JOIN products p ON s.product_id = p.id
    WHERE DATE(s.sale_datetime) = '$today'
    ORDER BY s.sale_datetime DESC
";
$result = mysqli_query($conn, $query);

$total_sales  = 0;
$total_profit = 0;

// Page title
$page_title = "Today's Sales Summary";
?>
<!DOCTYPE html>
<html>
<head>
    <title><?= $page_title ?></title>
    <?php include("head.php"); ?>

    <style>
        body {
            font-family: 'Poppins', Arial, sans-serif;
            background: var(--bg-main);
            margin: 0;
            color: var(--text-main);
        }

        /* Content area to the right of sidebar */
        .content-area {
            margin-left: 260px;
            padding: 25px 30px;
        }

        @media(max-width: 768px){
            .content-area {
                margin-left: 80px;
                padding: 20px;
            }
        }

        .page-header {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 6px;
            margin-bottom: 18px;
        }

        .page-title {
            font-size: 22px;
            font-weight: 600;
            color: var(--text-heading);
            text-align: center;
        }

        .page-subtitle {
            font-size: 13px;
            color: #f4b400;
            text-align: center;
        }

        /* Link back to dashboard */
        .link-row {
            text-align: center;
            margin-bottom: 18px;
        }

        .styled-link {
            padding: 9px 18px;
            background: var(--accent-gold);
            color: var(--bg-main);
            text-decoration: none;
            border-radius: 6px;
            font-weight: 600;
            font-size: 13px;
            display: inline-block;
            border: none;
        }

        .styled-link:hover {
            background: var(--accent-gold-soft);
        }

        /* Card around table */
        .page-card {
            background: var(--bg-card);
            border-radius: 14px;
            padding: 18px 22px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.35);
            border: 1px solid #0a4a85;
            color: var(--text-main);
        }

        body[data-theme="light"] .page-card {
            box-shadow: 0 12px 30px rgba(15,23,42,0.12);
            border-color: rgba(148,163,184,0.55);
        }

        .page-card-title {
            font-size: 16px;
            font-weight: 500;
            margin-bottom: 10px;
            color: var(--text-heading);
        }

        /* Table wrapper */
        .table-wrapper {
            width: 100%;
            overflow-x: auto;
            margin-top: 6px;
        }

        table {
            width: 100%;
            min-width: 1100px;
            border-collapse: collapse;
            background: var(--bg-card);
            color: var(--text-main);
            border-radius: 10px;
        }

        thead tr {
            background: var(--bg-table-head);
        }

        th,
        td {
            padding: 10px 12px;
            border: 1px solid rgba(255,255,255,0.15);
            text-align: center;
            font-size: 13px;
            white-space: nowrap;
        }

        th {
            color: #ffffff;
            font-weight: 600;
        }

        tbody tr {
            background: var(--bg-table-row);
        }

        tbody tr:nth-child(even) {
            background: var(--bg-table-row);
        }

        tbody tr:hover {
            background: var(--bg-table-hover);
            color: #ffffff;
        }

        body[data-theme="light"] th {
            color: #111827;
            border-color: rgba(148,163,184,0.5);
        }

        body[data-theme="light"] td {
            border-color: rgba(148,163,184,0.35);
        }

        body[data-theme="light"] tbody tr {
            background: var(--bg-table-row);
        }

        body[data-theme="light"] tbody tr:nth-child(even) {
            background: var(--bg-table-row);
        }

        body[data-theme="light"] tbody tr:hover {
            background: var(--bg-table-hover);
            color: #111827;
        }

        .numeric {
            text-align: right;
        }

        /* Totals card */
        .totals-box {
            margin-top: 20px;
            padding: 14px 18px;
            background: var(--bg-card);
            border-left: 6px solid #f4b400;
            border-radius: 10px;
            text-align: center;
            font-weight: 600;
            font-size: 14px;
            box-shadow: 0 4px 10px rgba(0,0,0,0.3);
            color: var(--text-main);
        }

        body[data-theme="light"] .totals-box {
            box-shadow: 0 10px 24px rgba(15,23,42,0.12);
            border-left-color: #facc15;
        }

        .totals-box p {
            margin: 4px 0;
        }

        .totals-box span.label {
            color: var(--text-main);
        }

        .totals-box span.value {
            color: #f4b400;
        }

        footer {
            background: transparent;
        }
    </style>
</head>

<body>

<?php include("sidebar.php"); ?>

<div class="content-area">

    <div class="page-header">
        <div class="page-title">Today's Sales Summary</div>
        <div class="page-subtitle">Sales summary for <?= htmlspecialchars($today) ?></div>
    </div>

    
    <div class="page-card">
        <div class="page-card-title">Sales for <?= htmlspecialchars($today) ?></div>

        <div class="table-wrapper">
            <table>
                <thead>
                    <tr>
                        <th>Date & Time</th>
                        <th>Cashier</th>
                        <th>Product</th>
                        <th>Quantity</th>
                        <th>Buying Price (KES)</th>
                        <th>Selling Price (KES)</th>
                        <th>Discount (KES)</th>
                        <th>Total Sale (KES)</th>
                        <th>Profit (KES)</th>
                    </tr>
                </thead>
                <tbody>
                <?php while ($row = mysqli_fetch_assoc($result)):
                    $discount    = $row['discount'] ?? 0;
                    $total_sale  = ($row['selling_price'] * $row['quantity']) - $discount;
                    $profit      = $total_sale - ($row['buying_price'] * $row['quantity']);

                    $total_sales  += $total_sale;
                    $total_profit += $profit;
                ?>
                    <tr>
                        <td><?= date('Y-m-d H:i:s', strtotime($row['sale_datetime'])) ?></td>
                        <td><?= htmlspecialchars($row['cashier']) ?></td>
                        <td><?= htmlspecialchars($row['product_name']) ?></td>
                        <td class="numeric"><?= $row['quantity'] ?></td>
                        <td class="numeric"><?= number_format($row['buying_price'], 2) ?></td>
                        <td class="numeric"><?= number_format($row['selling_price'], 2) ?></td>
                        <td class="numeric"><?= number_format($discount, 2) ?></td>
                        <td class="numeric"><?= number_format($total_sale, 2) ?></td>
                        <td class="numeric"><?= number_format($profit, 2) ?></td>
                    </tr>
                <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>

    <div class="totals-box">
        <p>
            <span class="label">Total Sales:</span>
            <span class="value">KES <?= number_format($total_sales, 2) ?></span>
        </p>
        <p>
            <span class="label">Total Profit:</span>
            <span class="value">KES <?= number_format($total_profit, 2) ?></span>
        </p>
    </div>

    <?php include 'footer.php'; ?>

</div> <!-- end content-area -->

</body>
</html>
