<?php
session_start();
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit();
}

include("db_connect.php");

// Notifications
$success = "";
$error   = "";

// Display alerts
if (isset($_GET['added']))   $success = "Customer added successfully!";
if (isset($_GET['updated'])) $success = "Customer updated successfully!";
if (isset($_GET['deleted'])) $success = "Customer deleted successfully!";
if (isset($_GET['error']))   $error   = "Please fill in all fields.";

// Fetch customers
$customers = mysqli_query($conn, "SELECT * FROM customers ORDER BY id DESC");

// Page title for head.php
$page_title = "Customer Details";
?>
<!DOCTYPE html>
<html>
<head>
    <title><?= htmlspecialchars($page_title) ?></title>
    <?php include('head.php'); ?>

    <style>
        body {
            font-family: 'Poppins', Arial, sans-serif;
            background: var(--bg-main);
            margin: 0;
            color: var(--text-main);
        }

        /* Content to the right of sidebar */
        .content-area {
            margin-left: 260px;
            padding: 25px 30px;
        }

        @media (max-width: 768px) {
            .content-area {
                margin-left: 80px;
                padding: 20px;
            }
        }

        .customer-container {
            width: 100%;
            max-width: 1100px;
            margin: 0 auto 30px auto;
            background: var(--bg-card);
            padding: 24px 26px;
            border-radius: 14px;
            box-shadow: 0 6px 18px rgba(0,0,0,0.4);
            border: 1px solid #0a4a85;
            color: var(--text-main);
        }

        body[data-theme="light"] .customer-container {
            border-color: rgba(148,163,184,0.55);
            box-shadow: 0 12px 28px rgba(15,23,42,0.10);
        }

        h2 {
            color: var(--text-heading);
            margin-bottom: 10px;
            font-size: 22px;
            font-weight: 600;
        }

        h3 {
            color: var(--text-heading);
            margin-top: 20px;
            margin-bottom: 8px;
            font-size: 16px;
            font-weight: 500;
        }

        /* Form */
        form input {
            padding: 9px 10px;
            width: 100%;
            margin-bottom: 12px;
            border-radius: 6px;
            border: 1px solid #0a4a85;
            background: var(--bg-table-head);
            color: var(--text-main);
            font-size: 14px;
        }

        form input::placeholder {
            color: rgba(148,163,184,0.9);
        }

        form input:focus {
            outline: none;
            background: var(--bg-table-hover);
            border-color: var(--accent-gold);
        }

        button, .btn {
            background: var(--accent-gold);
            border: none;
            padding: 10px 15px;
            color: var(--bg-main);
            border-radius: 6px;
            cursor: pointer;
            font-size: 14px;
            display: block;
            width: 100%;
            margin-top: 8px;
            text-align: center;
            font-weight: 600;
            text-decoration: none;
        }

        button:hover, .btn:hover {
            background: var(--accent-gold-soft);
        }

        .message, .error {
            padding: 10px;
            margin-bottom: 10px;
            border-radius: 6px;
            border-left-width: 5px;
            border-left-style: solid;
            font-size: 13px;
        }

        .message {
            background: #d4edda;
            color: #155724;
            border-left-color: #28a745;
        }

        .error {
            background: #f8d7da;
            color: #721c24;
            border-left-color: #dc3545;
        }

        /* Table */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 18px;
            background: var(--bg-card);
            color: var(--text-main);
            border-radius: 10px;
            overflow: hidden;
        }

        th, td {
            border: 1px solid rgba(0,0,0,0.12);
            padding: 10px 10px;
            text-align: center;
            font-size: 13px;
            white-space: nowrap;
        }

        body:not([data-theme="light"]) th,
        body:not([data-theme="light"]) td {
            border-color: rgba(255,255,255,0.15);
        }

        th {
            background: var(--bg-table-head);
            color: var(--text-heading);
            font-weight: 600;
        }

        tbody tr {
            background: var(--bg-table-row);
        }

        tbody tr:nth-child(even) {
            background: var(--bg-table-row);
        }

        tbody tr:hover {
            background: var(--bg-table-hover);
            color: #ffffff;
        }

        body[data-theme="light"] tbody tr:hover {
            color: #111827;
        }

        .action-btn {
            padding: 6px 12px;
            border-radius: 5px;
            color: #ffffff;
            text-decoration: none;
            font-size: 12px;
            display: inline-block;
            margin: 0 3px;
        }

        .edit {
            background: #17a2b8;
        }

        .edit:hover {
            background: #0f7482;
        }

        .delete {
            background: #dc3545;
        }

        .delete:hover {
            background: #a71d2a;
        }

        .back-btn {
            margin-top: 20px;
        }

        footer {
            background: transparent;
        }
    </style>
</head>
<body>

<?php include 'sidebar.php'; ?>

<div class="content-area">
    <div class="customer-container">

        <h2>Customer Information</h2>

        <?php if ($success): ?>
            <div class="message"><?= htmlspecialchars($success); ?></div>
        <?php endif; ?>

        <?php if ($error): ?>
            <div class="error"><?= htmlspecialchars($error); ?></div>
        <?php endif; ?>

        <!-- Add Customer -->
        <form method="POST" action="save_customer.php">
            <input type="text" name="customer_name" placeholder="Customer Name" required>
            <input type="text" name="phone" placeholder="Phone Number" required>
            <button type="submit">Save Customer</button>
        </form>

        <h3>Saved Customers</h3>

        <table>
            <tr>
                <th>ID</th>
                <th>Customer Name</th>
                <th>Phone</th>
                <th>Date Added</th>
                <th>Actions</th>
            </tr>

            <?php while ($row = mysqli_fetch_assoc($customers)): ?>
                <tr>
                    <td><?= $row['id'] ?></td>
                    <td><?= htmlspecialchars($row['customer_name']) ?></td>
                    <td><?= htmlspecialchars($row['phone']) ?></td>
                    <td><?= date('Y-m-d H:i', strtotime($row['created_at'])) ?></td>
                    <td>
                        <a href="admin_edit_customer.php?id=<?= $row['id'] ?>" class="action-btn edit">Edit</a>
                        <a href="delete_customer.php?id=<?= $row['id'] ?>"
                           onclick="return confirm('Are you sure you want to delete this customer?');"
                           class="action-btn delete">Delete</a>
                    </td>
                </tr>
            <?php endwhile; ?>
        </table>

        <a href="admin_dashboard.php" class="btn back-btn">⬅ Return to Admin Dashboard</a>

    </div>

    <?php include 'footer.php'; ?>
</div>

</body>
</html>
