<?php
session_start();
if (!isset($_SESSION['username']) || $_SESSION['role'] !== 'admin') {
    header("Location: login.html?error=unauthorized");
    exit();
}

include 'db_connect.php';

if (empty($_GET['id'])) {
    die("No user selected.");
}
$user_id = (int)$_GET['id'];

$page_title = "View User";

/* Fetch user */
$stmt = $conn->prepare("SELECT * FROM users WHERE id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$userResult = $stmt->get_result();
$user       = $userResult->fetch_assoc();
$stmt->close();

if (!$user) {
    die("User not found.");
}

/* Full name + initials */
$fullName = trim(($user['first_name'] ?? '') . ' ' . ($user['last_name'] ?? ''));
$initials = '';

if (!empty($user['first_name'])) {
    $initials .= strtoupper($user['first_name'][0]);
}
if (!empty($user['last_name'])) {
    $initials .= strtoupper($user['last_name'][0]);
}
if ($initials === '' && !empty($user['username'])) {
    $initials = strtoupper($user['username'][0]);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title><?= htmlspecialchars($page_title) ?></title>
    <?php include 'head.php'; ?>
    <style>
        body {
            font-family: 'Poppins', Arial, sans-serif;
            background: var(--bg-main);
            margin: 0;
            color: var(--text-main);
        }

        /* Layout next to sidebar */
        .content-area {
            margin-left: 260px;
            padding: 28px 32px 32px;
            min-height: 100vh;
            box-sizing: border-box;
        }

        @media(max-width: 1000px) {
            .content-area {
                margin-left: 80px;
                padding: 20px;
            }
        }

        .page-header {
            max-width: 1100px;
            margin: 0 auto 18px;
            display: flex;
            justify-content: space-between;
            align-items: flex-end;
            flex-wrap: wrap;
            gap: 8px;
        }

        .page-title {
            font-size: 22px;
            font-weight: 600;
            color: var(--text-heading);
        }

        .page-subtitle {
            font-size: 13px;
            color: var(--accent-gold);
            margin-top: 4px;
        }

        .page-header-right a.back-link-top {
            font-size: 13px;
            text-decoration: none;
            color: var(--accent-gold);
        }

        .page-header-right a.back-link-top:hover {
            text-decoration: underline;
        }

        /* Main card layout */
        .page-layout {
            max-width: 1100px;
            margin: 0 auto;
        }

        .page-card {
            background: var(--bg-card);
            border-radius: 16px;
            padding: 22px 26px 24px;
            box-shadow: 0 10px 28px rgba(0,0,0,0.35);
            border: 1px solid #0a4a85;
            color: var(--text-main);
            display: grid;
            grid-template-columns: minmax(0, 0.9fr) minmax(0, 1.4fr);
            gap: 20px;
        }

        body[data-theme="light"] .page-card {
            border-color: rgba(148,163,184,0.55);
            box-shadow: 0 14px 34px rgba(15,23,42,0.10);
        }

        @media (max-width: 900px) {
            .page-card {
                grid-template-columns: minmax(0, 1fr);
            }
        }

        /* Left summary column */
        .user-summary {
            border-right: 1px solid rgba(148,163,184,0.45);
            padding-right: 18px;
        }

        @media (max-width: 900px) {
            .user-summary {
                border-right: none;
                border-bottom: 1px solid rgba(148,163,184,0.45);
                padding-right: 0;
                padding-bottom: 16px;
                margin-bottom: 10px;
            }
        }

        .user-avatar {
            width: 76px;
            height: 76px;
            border-radius: 999px;
            display: flex;
            align-items: center;
            justify-content: center;
            background: radial-gradient(circle at 30% 0%, rgba(250,204,21,0.25), transparent 60%), #02101f;
            border: 2px solid rgba(250,204,21,0.7);
            color: #facc15;
            font-size: 28px;
            font-weight: 600;
            margin-bottom: 10px;
        }

        body[data-theme="light"] .user-avatar {
            background: radial-gradient(circle at 30% 0%, rgba(250,204,21,0.22), transparent 60%), #ffffff;
        }

        .user-main-name {
            font-size: 18px;
            font-weight: 600;
            margin-bottom: 2px;
            color: var(--text-heading);
        }

        .user-username {
            font-size: 13px;
            color: #9ca3af;
            margin-bottom: 6px;
        }

        body[data-theme="light"] .user-username {
            color: #6b7280;
        }

        .role-badge {
            display: inline-flex;
            align-items: center;
            padding: 4px 10px;
            border-radius: 999px;
            font-size: 11px;
            text-transform: uppercase;
            letter-spacing: 0.08em;
            background: rgba(37,99,235,0.16);
            color: #bfdbfe;
            border: 1px solid rgba(59,130,246,0.6);
            margin-bottom: 10px;
        }

        body[data-theme="light"] .role-badge {
            background: #e0f2fe;
            color: #1d4ed8;
            border-color: #bfdbfe;
        }

        .user-meta-small {
            font-size: 12px;
            color: #9ca3af;
            margin-top: 6px;
            line-height: 1.5;
        }

        body[data-theme="light"] .user-meta-small {
            color: #6b7280;
        }

        /* Right detail column */
        .detail-section-title {
            font-size: 15px;
            font-weight: 600;
            margin-bottom: 10px;
            color: var(--text-heading);
        }

        .detail-grid {
            display: grid;
            grid-template-columns: repeat(2, minmax(0, 1fr));
            gap: 10px 18px;
        }

        @media (max-width: 700px) {
            .detail-grid {
                grid-template-columns: minmax(0, 1fr);
            }
        }

        .detail-item {
            font-size: 14px;
        }

        .detail-label {
            font-size: 11px;
            text-transform: uppercase;
            letter-spacing: 0.08em;
            color: #9ca3af;
            margin-bottom: 3px;
        }

        .detail-value {
            font-weight: 500;
            color: var(--text-main);
        }

        body[data-theme="light"] .detail-label {
            color: #6b7280;
        }

        .back-link-bottom {
            display: inline-flex;
            align-items: center;
            gap: 4px;
            margin-top: 16px;
            font-size: 13px;
            color: var(--accent-gold);
            text-decoration: none;
        }

        .back-link-bottom:hover {
            text-decoration: underline;
        }

        footer {
            background: transparent;
        }
    </style>
</head>
<body>

<?php include 'sidebar.php'; ?>

<div class="content-area">

    <div class="page-header">
        <div>
            <div class="page-title">View User #<?= (int)$user['id']; ?></div>
            <div class="page-subtitle">Detailed profile information for this system user.</div>
        </div>
        <div class="page-header-right">
            <a href="manage_users.php" class="back-link-top">← Back to users</a>
        </div>
    </div>

    <div class="page-layout">
        <div class="page-card">

            <!-- LEFT: SUMMARY -->
            <div class="user-summary">
                <div class="user-avatar">
                    <?= htmlspecialchars($initials ?: 'U'); ?>
                </div>
                <div class="user-main-name">
                    <?= htmlspecialchars($fullName ?: $user['username']); ?>
                </div>
                <div class="user-username">
                    @<?= htmlspecialchars($user['username']); ?>
                </div>
                <div class="role-badge">
                    <?= strtoupper(htmlspecialchars($user['role'])); ?>
                </div>

                <div class="user-meta-small">
                    <strong>User ID:</strong> <?= (int)$user['id']; ?><br>
                    <?php if (!empty($user['date_of_birth'])): ?>
                        <strong>DOB:</strong> <?= htmlspecialchars($user['date_of_birth']); ?><br>
                    <?php endif; ?>
                    <?php if (!empty($user['phone_number'])): ?>
                        <strong>Phone:</strong> <?= htmlspecialchars($user['phone_number']); ?>
                    <?php endif; ?>
                </div>
            </div>

            <!-- RIGHT: DETAIL GRID -->
            <div>
                <div class="detail-section-title">Personal &amp; Account Details</div>

                <div class="detail-grid">
                    <div class="detail-item">
                        <div class="detail-label">Username</div>
                        <div class="detail-value"><?= htmlspecialchars($user['username']); ?></div>
                    </div>

                    <div class="detail-item">
                        <div class="detail-label">Role</div>
                        <div class="detail-value"><?= ucfirst(htmlspecialchars($user['role'])); ?></div>
                    </div>

                    <div class="detail-item">
                        <div class="detail-label">First name</div>
                        <div class="detail-value"><?= htmlspecialchars($user['first_name'] ?? '-'); ?></div>
                    </div>

                    <div class="detail-item">
                        <div class="detail-label">Last name</div>
                        <div class="detail-value"><?= htmlspecialchars($user['last_name'] ?? '-'); ?></div>
                    </div>

                    <div class="detail-item">
                        <div class="detail-label">Date of birth</div>
                        <div class="detail-value"><?= htmlspecialchars($user['date_of_birth'] ?? '-'); ?></div>
                    </div>

                    <div class="detail-item">
                        <div class="detail-label">ID number</div>
                        <div class="detail-value"><?= htmlspecialchars($user['id_number'] ?? '-'); ?></div>
                    </div>

                    <div class="detail-item">
                        <div class="detail-label">Place of birth</div>
                        <div class="detail-value"><?= htmlspecialchars($user['place_of_birth'] ?? '-'); ?></div>
                    </div>

                    <div class="detail-item">
                        <div class="detail-label">Gender</div>
                        <div class="detail-value"><?= htmlspecialchars($user['gender'] ?? '-'); ?></div>
                    </div>

                    <div class="detail-item">
                        <div class="detail-label">Phone</div>
                        <div class="detail-value"><?= htmlspecialchars($user['phone_number'] ?? '-'); ?></div>
                    </div>
                </div>

                <a href="manage_users.php" class="back-link-bottom">
                    <span>←</span> <span>Back to users</span>
                </a>
            </div>

        </div>
    </div>

</div>

<?php include 'footer.php'; ?>
</body>
</html>
