<?php
session_start();
if (!isset($_SESSION['username']) || $_SESSION['role'] !== 'admin') {
    header("Location: login.html");
    exit();
}

include 'db_connect.php';

// Fetch all MPESA payments
$sql = "SELECT * FROM mpesa_payments ORDER BY payment_time DESC";
$result = $conn->query($sql);

// Grand total
$grand_total_result = $conn->query("SELECT SUM(amount) AS total_amount FROM mpesa_payments");
$grand_total = $grand_total_result->fetch_assoc()['total_amount'] ?? 0;

$page_title = "MPESA Payments";
include('head.php'); 
?>

<!DOCTYPE html>
<html lang="en">
<head>
<style>

/* ----- MAIN CONTENT SHIFT RIGHT ----- */
.content-area {
    margin-left: 260px;
    padding: 25px;
}

@media(max-width: 768px){
    .content-area { margin-left: 80px; }
}

/* ----- HEADER ----- */
h2 {
    text-align: center;
    font-weight: 700;
    color: #0056b3;
    margin-bottom: 20px;
}

/* ----- TABLE ----- */
.table-container {
    width: 95%;
    margin: auto;
    overflow-x: auto;
}

table {
    width: 100%;
    border-collapse: collapse;
    background: #ffffff;
    border-radius: 10px;
    overflow: hidden;
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
}

th, td {
    padding: 12px;
    color: black;
    text-align: center;
    border-bottom: 1px solid #ddd;
}

th {
    background: #013a63;
    color: white;
    font-size: 15px;
}

tr:nth-child(even) {
    background: #f8f9fa;
}

tr:hover {
    background: #eaf3ff;
}

/* Totals card */
.total-box {
    margin: 20px auto;
    padding: 15px;
    width: 95%;
    background: #cce5ff;
    border-left: 6px solid #0056b3;
    text-align: center;
    font-weight: 700;
    border-radius: 8px;
    color: #003566;
}

/* Back button */
.back-btn {
    display: block;
    width: 250px;
    margin: 25px auto;
    padding: 12px;
    background: #0056b3;
    color: white;
    text-align: center;
    border-radius: 6px;
    font-weight: 600;
    text-decoration: none;
}

.back-btn:hover {
    background: #003d80;
}
</style>
</head>

<body>

<?php include('sidebar.php'); ?>

<div class="content-area">

    <h2>MPESA Payments (Till & Paybill)</h2>

    <div class="table-container">
        <table>
            <tr>
                <th>ID</th>
                <th>Customer</th>
                <th>Phone</th>
                <th>Method</th>
                <th>Amount (KES)</th>
                <th>Transaction Code</th>
                <th>Payment Time</th>
            </tr>

            <?php if ($result && $result->num_rows > 0): ?>
                <?php 
                $page_total = 0;
                while ($row = $result->fetch_assoc()):
                    $page_total += $row['amount'];
                ?>
                <tr>
                    <td><?= $row['id'] ?></td>
                    <td><?= htmlspecialchars($row['customer_name']) ?></td>
                    <td><?= htmlspecialchars($row['phone_number']) ?></td>
                    <td><?= htmlspecialchars($row['method']) ?></td>
                    <td>KES <?= number_format($row['amount'], 2) ?></td>
                    <td><?= htmlspecialchars($row['transaction_code']) ?></td>
                    <td><?= $row['payment_time'] ?></td>
                </tr>
                <?php endwhile; ?>

                <!-- Page total row -->
                <tr style="font-weight:bold; background:#e3f2fd;">
                    <td colspan="4">Page Total</td>
                    <td>KES <?= number_format($page_total, 2) ?></td>
                    <td colspan="2"></td>
                </tr>

            <?php else: ?>
                <tr>
                    <td colspan="7">No MPESA payments found.</td>
                </tr>
            <?php endif; ?>
        </table>
    </div>

    <!-- Grand Total -->
    <div class="total-box">
        Grand Total MPESA Payments: KES <?= number_format($grand_total, 2) ?>
    </div>

    <a href="admin_dashboard.php" class="back-btn">← Back to Dashboard</a>

</div>

<?php include 'footer.php'; ?>
</body>
</html>
