<?php 
if (!isset($page_title)) {
    $page_title = "Cashier Panel";
}
?>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title><?= htmlspecialchars($page_title); ?></title>

<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

<script>
// set theme ASAP to avoid flash
(function () {
    const saved = localStorage.getItem('cashierTheme');
    const theme = (saved === 'light' || saved === 'dark') ? saved : 'dark';
    document.documentElement.setAttribute('data-theme', theme);
})();
</script>

<style>
    /* STRONGER LIGHT THEME COLORS
   (keep your existing dark theme as-is) */
body[data-theme="light"] {
    --cash-bg-main:   #e5f6ff;   /* page background */
    --cash-bg-card:   #ffffff;   /* cards */
    --cash-bg-header: #ffffff;
    --cash-text-main: #020617;   /* main text – almost black */
    --cash-text-muted:#64748b;   /* descriptions */
    --cash-accent:    #06b6d4;   /* teal accent */
    --cash-border-soft: rgba(15,23,42,0.10);
}

/* Outer container a bit brighter and with clearer border */
body[data-theme="light"] .dashboard-inner {
    background: #f9fafb;
    border-color: #dbeafe;
    box-shadow: 0 18px 40px rgba(15,23,42,0.10);
}

/* Top bar text */
body[data-theme="light"] .cashier-topbar h1,
body[data-theme="light"] .cashier-topbar small {
    color: var(--cash-text-main);
}
body[data-theme="light"] .cashier-topbar small {
    color: var(--cash-text-muted);
}

/* Section subtitles & helper text */
body[data-theme="light"] .overview-sub,
body[data-theme="light"] .stat-caption,
body[data-theme="light"] .cash-card p {
    color: var(--cash-text-muted);
}

/* STAT CARDS – make them solid white with a clearer outline */
body[data-theme="light"] .stat-card {
    background: #ffffff;
    border-color: #dbeafe;
    box-shadow: 0 14px 32px rgba(15,23,42,0.10);
}
body[data-theme="light"] .stat-label {
    color: #64748b;
}
body[data-theme="light"] .stat-chip {
    background: #e0f2fe;
    border-color: #bfdbfe;
    color: #0f172a;
}

/* Quick action cards – more contrast vs background */
body[data-theme="light"] .cash-card {
    background: #ffffff;
    border-left-color: #06b6d4;
    box-shadow: 0 10px 24px rgba(15,23,42,0.08);
}
body[data-theme="light"] .cash-card:hover {
    background: #f9fafb;
    border-left-color: #0ea5e9;
}

/* “Cashier mode · date” pill */
body[data-theme="light"] .overview-pill {
    background: #e0f2fe;
    border-color: #0ea5e9;
    color: #0f172a;
}
body[data-theme="light"] .overview-pill-dot {
    box-shadow: 0 0 0 4px rgba(34,197,94,0.25);
}

:root {
    /* DARK THEME (default) */
    --cash-bg-main: #001f3f;
    --cash-bg-sidebar: #001730;
    --cash-bg-card: #012a57; 
    --cash-bg-header: #001730;
    --cash-bg-hover: #014b94;

    --cash-accent-main:  #24f3ff; /* aqua */
    --cash-accent-soft:  #82EEFD;

    --cash-text-main:  #F9FAFB;
    --cash-text-muted: #9CA3AF;
    --cash-border-soft: rgba(255,255,255,0.18);
}

/* LIGHT THEME OVERRIDES */
html[data-theme="light"] {
    --cash-bg-main: #f4f9ff;
    --cash-bg-sidebar: #ffffff;
    --cash-bg-card: #ffffff;
    --cash-bg-header: #ffffff;
    --cash-bg-hover: #e0f7ff;

    --cash-accent-main:  #06b6d4; /* cyan */
    --cash-accent-soft:  #22d3ee;

    --cash-text-main:  #0f172a;
    --cash-text-muted: #6b7280;
    --cash-border-soft: rgba(148,163,184,0.35);
}

/* reset */

* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
    font-family: "Poppins", sans-serif;
}

html, body {
    height: 100%;
}

body {
    background: var(--cash-bg-main);
    color: var(--cash-text-main);
    display: flex;
    flex-direction: column;
}

/* layout shell */

.cashier-shell {
    flex: 1;
    display: flex;
    min-height: 0;
    transition: all 0.25s ease;
}

/* sidebar (fixed so it does NOT scroll with content) */

.cashier-sidebar {
    width: 240px;
    background: var(--cash-bg-sidebar);
    border-right: 2px solid var(--cash-accent-main);
    box-shadow: 4px 0 10px rgba(0, 0, 0, 0.45);
    padding: 18px 14px;
    display: flex;
    flex-direction: column;
    gap: 14px;

    position: fixed;
    left: 0;
    top: 0;
    height: 100vh;
    z-index: 30;

    transform: translateX(0);
    transition: transform 0.25s ease, box-shadow 0.25s ease, border-right 0.25s ease, background 0.25s ease;
}

/* main content (pushed to the right of fixed sidebar) */

.cashier-main {
    flex: 1;
    padding: 22px 26px 32px;
    min-width: 0;
    margin-left: 240px;
}

/* collapsed state: hide sidebar, content goes full width */

.cashier-shell.collapsed .cashier-sidebar {
    transform: translateX(-100%);
    border-right: none;
    box-shadow: none;
}

.cashier-shell.collapsed .cashier-main {
    margin-left: 0;
}

/* brand */

.cashier-brand {
    display: flex;
    align-items: center;
    gap: 10px;
    margin-bottom: 6px;
}

.cashier-logo {
    width: 36px;
    height: 36px;
    border-radius: 12px;
    background: var(--cash-accent-main);
    display: flex;
    align-items: center;
    justify-content: center;
    color: #001730;
    font-weight: 800;
    font-size: 18px;
}

.cashier-brand span {
    font-weight: 600;
    font-size: 18px;
    color: var(--cash-accent-soft);
}

/* sidebar nav */

.cashier-nav {
    margin-top: 6px;
    display: flex;
    flex-direction: column;
    gap: 4px;
}

.cashier-nav a {
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 9px 10px;
    border-radius: 8px;
    text-decoration: none;
    font-size: 14px;
    color: var(--cash-text-main);
    transition: background 0.2s, transform 0.2s, box-shadow 0.2s, color 0.2s;
}

.cashier-nav a .icon {
    width: 18px;
    text-align: center;
}

.cashier-nav a:hover {
    background: var(--cash-bg-hover);
    color: var(--cash-accent-main);
    transform: translateX(3px);
    box-shadow: 0 0 12px rgba(0, 255, 239, 0.30);
}

.cashier-nav a.active {
    background: linear-gradient(90deg,
        var(--cash-accent-main),
        var(--cash-accent-soft)
    );
    color: #001730;
}

/* top bar */

.cashier-topbar {
    background: var(--cash-bg-header);
    border-radius: 12px;
    border: 1px solid var(--cash-border-soft);
    padding: 10px 16px;
    margin-bottom: 20px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    gap: 12px;
    background-image: linear-gradient(
        90deg,
        rgba(34,211,238,0.18),
        rgba(148,163,184,0.03)
    );
}

html[data-theme="light"] .cashier-topbar {
    background-image: linear-gradient(
        90deg,
        rgba(34,211,238,0.12),
        rgba(255,255,255,1)
    );
}

.cashier-topbar-left {
    display: flex;
    flex-direction: column;
    gap: 2px;
}

.cashier-topbar h1 {
    font-size: 19px;
    font-weight: 600;
}

.cashier-topbar small {
    font-size: 13px;
    color: var(--cash-text-muted);
}

/* top-bar right area (nav + buttons) */

.cashier-topbar-right {
    display: flex;
    align-items: center;
    gap: 10px;
}

.cashier-topnav {
    display: flex;
    align-items: center;
    gap: 6px;
}

.cashier-topnav a {
    padding: 6px 10px;
    border-radius: 999px;
    font-size: 12px;
    text-decoration: none;
    color: var(--cash-text-muted);
    border: 1px solid transparent;
    transition: background 0.2s, color 0.2s, border-color 0.2s;
}

.cashier-topnav a:hover {
    background: rgba(15,23,42,0.25);
    color: var(--cash-accent-soft);
}

html[data-theme="light"] .cashier-topnav a:hover {
    background: #e0f7ff;
    color: #0369a1;
}

.cashier-topnav a.active {
    background: var(--cash-accent-main);
    color: #001730;
    border-color: transparent;
}

/* sidebar toggle button */

.cashier-toggle {
    border: none;
    border-radius: 999px;
    padding: 7px 12px;
    background-image: linear-gradient(90deg,
        var(--cash-accent-main),
        var(--cash-accent-soft)
    );
    color: #001730;
    font-weight: 600;
    cursor: pointer;
    font-size: 13px;
}

/* theme toggle button */

.cashier-theme-toggle {
    border-radius: 999px;
    border: 1px solid var(--cash-border-soft);
    padding: 6px 11px;
    background: transparent;
    color: var(--cash-text-main);
    font-size: 12px;
    display: inline-flex;
    align-items: center;
    gap: 6px;
    cursor: pointer;
}

.cashier-theme-toggle span.icon {
    font-size: 14px;
}

.cashier-theme-toggle:hover {
    background: rgba(15,23,42,0.35);
}

html[data-theme="light"] .cashier-theme-toggle:hover {
    background: #e5f3ff;
}

/* dashboard cards */

.cashier-cards {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(260px, 1fr));
    gap: 18px;
    align-items: stretch;
}

.cash-card {
    background: var(--cash-bg-card);
    border-radius: 14px;
    padding: 16px 18px;
    border-left: 4px solid var(--cash-accent-main);
    box-shadow: 0 4px 14px rgba(0, 0, 0, 0.35);
}

html[data-theme="light"] .cash-card {
    box-shadow: 0 8px 20px rgba(15,23,42,0.10);
}

.cash-card h3 {
    font-size: 15px;
    margin-bottom: 6px;
}

.cash-card p {
    font-size: 13px;
    color: var(--cash-text-muted);
}

/* helpers */

.dashboard-inner {
    max-width: 1280px;
    margin: 0 auto;
}

.stat-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
    gap: 14px;
    margin-bottom: 20px;
}

.logout-row {
    margin-top: 26px;
    text-align: right;
}

/* logout button */

.btn-logout {
    display: inline-flex;
    padding: 9px 16px;
    border-radius: 8px;
    background: #e74c3c;
    color: #ffffff;
    text-decoration: none;
    font-weight: 600;
    font-size: 13px;
}

.btn-logout:hover {
    background: #c0392b;
}

/* footer pinned bottom & not under sidebar */

footer,
footer.footer {
    background: transparent;
    color: var(--cash-accent-soft);
    border-top: none;
    text-align: center;
    font-size: 13px;
    padding: 10px 16px;
    margin-top: auto;
}

/* push footer to align with content area on desktop */
@media (min-width: 901px) {
    footer,
    footer.footer {
        margin-left: 240px;
    }
}

/* when sidebar collapsed we can add a class on body to reset footer margin if you want */

/* mobile */

@media (max-width: 900px) {
    .cashier-shell {
        flex-direction: column;
    }

    .cashier-sidebar {
        width: 240px;
    }

    .cashier-main {
        padding: 18px 16px 26px;
        margin-left: 0;
    }

    footer,
    footer.footer {
        margin-left: 0;
    }

    .cashier-topbar {
        flex-direction: column;
        align-items: flex-start;
    }

    .cashier-topbar-right {
        width: 100%;
        justify-content: space-between;
    }
}

</style>


<script>
function toggleCashierSidebar() {
    const shell = document.querySelector('.cashier-shell');
    if (shell) {
        shell.classList.toggle('collapsed');
    }
}

// theme toggle used in topbar button
function toggleCashierTheme() {
    const html = document.documentElement;
    const current = html.getAttribute('data-theme') || 'dark';
    const next = current === 'dark' ? 'light' : 'dark';
    html.setAttribute('data-theme', next);
    localStorage.setItem('cashierTheme', next);
}
</script>
