<?php
session_start();
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit();
}

require 'db_connect.php';

// Fetch products with low stock (less than 10)
$lowStockQuery = $conn->query("
    SELECT id, name, quantity 
    FROM products 
    WHERE quantity < 5
    ORDER BY quantity ASC
");

// Title for head.php if you use it
$page_title = "Low Stock Alerts";
?>
<!DOCTYPE html>
<html>
<head>
    <title><?= htmlspecialchars($page_title) ?></title>
    <?php include("head.php"); ?>

    <style>
        body {
            font-family: 'Poppins', Arial, sans-serif;
            background: var(--bg-main, #001f3f);
            margin: 0;
            color: var(--text-main);
        }

        /* ============= LAYOUT + TOPBAR (UNIFORM WITH EXPENSES PAGE) ============= */
        .content-wrapper {
            margin-left: 260px; /* space for admin sidebar */
            padding: 24px 26px 32px;
            min-height: 100vh;
            box-sizing: border-box;
            background:
                radial-gradient(circle at top left, rgba(0,255,239,0.08), transparent 55%),
                var(--bg-main, #001f3f);
            transition: margin-left 0.3s ease, background 0.3s ease;
        }

        .content-wrapper.fullwidth {
            margin-left: 0;
        }

        .content-inner {
            max-width: 1500px;
            margin: 0 auto;
        }

        .topbar {
            background: var(--bg-sidebar);
            padding: 14px 18px;
            margin-bottom: 20px;
            border-radius: 12px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            border: 1px solid #B8860B;
            box-shadow: 0 6px 18px rgba(0,0,0,0.5);
            color: brown;
        }

        .topbar-left {
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .topbar-right {
            display: flex;
            align-items: center;
            gap: 10px;
            font-size: 13px;
        }

        .topbar-title {
            font-weight: 600;
            font-size: 15px;
            letter-spacing: 0.03em;
        }

        .menu-btn {
            font-size: 22px;
            cursor: pointer;
            color: var(--accent-gold, #f4b400);
            transition: 0.3s;
            line-height: 1;
        }

        .menu-btn:hover {
            color: #e6c34b;
        }

        .theme-toggle {
            border-radius: 999px;
            border: 1px solid rgba(184,134,11,0.7);
            padding: 6px 12px;
            background: rgba(0,0,0,0.4);
            color: #f9f9f9;
            font-size: 12px;
            cursor: pointer;
        }

        .theme-toggle:hover {
            background: rgba(0,0,0,0.65);
        }

        .topbar-user strong {
            font-weight: 600;
        }

        /* Sidebar hide on toggle */
        #sidebar.hidden {
            transform: translateX(-260px);
        }

        @media (max-width: 900px) {
            .content-wrapper {
                margin-left: 0;
                padding: 18px 16px 24px;
            }
        }

        @media (max-width: 768px){
            .content-wrapper {
                padding: 18px 14px 24px;
            }
        }

        /* ============= PAGE CONTENT STYLES ============= */
        .page-header {
            display: block;
            text-align: center;
            margin-bottom: 18px;
        }

        .page-title {
            font-size: 22px;
            font-weight: 600;
            color: #ff6b6b; /* keep red to emphasize alert */
            margin-bottom: 4px;
        }

        .page-subtitle {
            font-size: 13px;
            color: var(--accent-gold);
        }

        .card-box {
            width: 100%;
            margin: 0 auto;
            background: var(--bg-card);
            padding: 20px 22px;
            border-radius: 14px;
            box-shadow: 0 4px 14px rgba(0,0,0,0.35);
            border: 1px solid #0a4a85;
            color: var(--text-main);
        }

        body[data-theme="light"] .card-box {
            border-color: rgba(148,163,184,0.6);
            box-shadow: 0 10px 24px rgba(15,23,42,0.08);
        }

        .card-title {
            font-size: 16px;
            font-weight: 500;
            color: var(--text-heading);
            margin-bottom: 10px;
        }

        /* Alerts */
        .alert {
            padding: 10px 12px;
            border-radius: 6px;
            margin-bottom: 12px;
            font-size: 13px;
        }
        .alert-success-custom {
            background: rgba(34,197,94,0.15);
            border-left: 5px solid #22c55e;
            color: #bbf7d0;
        }
        .alert-warning-custom {
            background: rgba(234,179,8,0.15);
            border-left: 5px solid #eab308;
            color: #fef9c3;
        }
        body[data-theme="light"] .alert-success-custom {
            background: #dcfce7;
            color: #166534;
        }
        body[data-theme="light"] .alert-warning-custom {
            background: #fef9c3;
            color: #854d0e;
        }

        /* Table wrapper */
        .table-wrapper {
            width: 100%;
            overflow-x: auto;
            margin-top: 8px;
        }

        table {
            width: 100%;
            min-width: 800px;
            border-collapse: collapse;
            background: var(--bg-card);
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 4px 12px rgba(0,0,0,0.35);
            color: var(--text-main);
        }

        thead tr {
            background: var(--bg-table-head);
        }

        th,
        td {
            padding: 9px 10px;
            font-size: 13px;
            border-bottom: 1px solid rgba(255,255,255,0.12);
            white-space: nowrap;
        }

        body[data-theme="light"] th,
        body[data-theme="light"] td {
            border-bottom-color: rgba(0,0,0,0.06);
        }

        th {
            color: var(--text-heading);
            font-weight: 600;
            text-align: center;
        }

        td {
            text-align: center;
        }

        /* left align product name */
        td.product-cell {
            text-align: left;
        }

        tbody tr {
            background: var(--bg-table-row);
        }

        tbody tr:nth-child(even) {
            background: var(--bg-table-row);
            opacity: 0.97;
        }

        tbody tr:hover {
            background: var(--bg-table-hover);
        }

        .numeric {
            text-align: right;
        }

        /* Custom status badges */
        .badge {
            display: inline-block;
            padding: 4px 10px;
            border-radius: 999px;
            font-size: 11px;
            font-weight: 600;
        }

        .badge-out {
            background: #e74c3c;
            color: #ffffff;
        }

        .badge-very-low {
            background: #ffc107;
            color: #001f3f;
        }

        .badge-low {
            background: #17a2b8;
            color: #001f3f;
        }

        footer {
            background: transparent !important;
        }
    </style>
</head>
<body>

<?php include("sidebar.php"); ?>

<div class="content-wrapper" id="content-wrapper">

    <!-- TOP BAR (SAME LOGIC AS EXPENSES PAGE) -->
    <div class="topbar">
        <div class="topbar-left">
            <span class="menu-btn" onclick="toggleAdminSidebar()">☰</span>
            <span class="topbar-title">Admin Panel</span>
        </div>
        <div class="topbar-right">
            <button class="theme-toggle" type="button" onclick="toggleAdminTheme()">
                🌓 Theme
            </button>
            <span class="topbar-user">
                Logged in as
                <strong><?= htmlspecialchars($_SESSION['username'] ?? 'User'); ?></strong>
            </span>
        </div>
    </div>

    <div class="content-inner">

        <div class="page-header">
            <div class="page-title">⚠ Low Stock Alert (Below 10)</div>
            <div class="page-subtitle">Monitor items that require restocking.</div>
        </div>

        <div class="card-box">
            <div class="card-title">Stock Status</div>

            <?php if ($lowStockQuery->num_rows == 0): ?>
                <div class="alert alert-success-custom">
                    All products have sufficient stock (10 units or more).
                </div>
            <?php else: ?>
                <div class="alert alert-warning-custom">
                    Some products are close to running out. Consider restocking them soon.
                </div>

                <div class="table-wrapper">
                    <table>
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Product Name</th>
                                <th>Quantity Left</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            $i = 1; 
                            while ($row = $lowStockQuery->fetch_assoc()): 
                            ?>
                            <tr>
                                <td><?= $i++ ?></td>
                                <td class="product-cell"><?= htmlspecialchars($row['name']) ?></td>
                                <td class="numeric"><?= $row['quantity'] ?></td>
                                <td>
                                    <?php if ($row['quantity'] == 0): ?>
                                        <span class="badge badge-out">Out of Stock</span>
                                    <?php elseif ($row['quantity'] < 5): ?>
                                        <span class="badge badge-very-low">Very Low</span>
                                    <?php else: ?>
                                        <span class="badge badge-low">Low</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>

        </div>

        <?php include("footer.php"); ?>

    </div> <!-- /content-inner -->
</div> <!-- /content-wrapper -->

<script>
function toggleAdminSidebar() {
    const sidebar = document.getElementById('sidebar');
    const wrapper = document.getElementById('content-wrapper');
    if (!sidebar || !wrapper) return;

    const isHidden = sidebar.classList.toggle('hidden');
    if (isHidden) {
        wrapper.classList.add('fullwidth');
    } else {
        wrapper.classList.remove('fullwidth');
    }
}
</script>

</body>
</html>
