<?php
session_start();
if (!isset($_SESSION['username']) || $_SESSION['role'] !== 'admin') {
    header("Location: login.html?error=unauthorized");
    exit();
}

include("db_connect.php");

date_default_timezone_set('Africa/Nairobi');
$today = date('Y-m-d');

// Fetch sales for today (receipt_id is already in s.*)
$query = "
    SELECT s.*, p.name AS product_name 
    FROM sales s
    JOIN products p ON s.product_id = p.id
    WHERE DATE(s.sale_datetime) = '$today'
    ORDER BY s.sale_datetime DESC
";
$result = mysqli_query($conn, $query);

$total_sales  = 0;
$total_profit = 0;

// Page title for <title> tag in head.php
$page_title = "Today's Sales Summary";

include("head.php"); // brings <!DOCTYPE html>, <head> etc.
?>

<body>

<?php include("sidebar.php"); ?>

<!-- MAIN PAGE WRAPPER (UNIFORM WITH OTHER PAGES) -->
<div class="content-wrapper" id="content-wrapper">

    <!-- TOP BAR (SHARED STYLE) -->
    <div class="topbar">
        <div class="topbar-left">
            <span class="menu-btn" onclick="toggleAdminSidebar()">☰</span>
            <span class="topbar-title">Admin Panel</span>
        </div>
        <div class="topbar-right">
            <button class="theme-toggle" type="button" onclick="toggleAdminTheme()">
                🌓 Theme
            </button>
            <span class="topbar-user">
                Logged in as
                <strong><?= htmlspecialchars($_SESSION['username'] ?? 'Admin'); ?></strong>
            </span>
        </div>
    </div>

    <!-- PAGE CONTENT -->
    <div class="page-header">
        <div class="page-header-center">
            <div class="page-title">Today's Sales Summary</div>
            <div class="page-subtitle">Sales summary for <?= htmlspecialchars($today) ?></div>
        </div>
    </div>

    <div class="page-card">
        <div class="page-card-title">Sales for <?= htmlspecialchars($today) ?></div>

        <div class="table-wrapper">
            <table class="table-theme today-sales-table">
                <thead>
                    <tr>
                        <th>Receipt #</th>
                        <th>Date & Time</th>
                        <th>Cashier</th>
                        <th>Product</th>
                        <th>Quantity</th>
                        <th>Buying Price (KES)</th>
                        <th>Selling Price (KES)</th>
                        <th>Discount (KES)</th>
                        <th>Total Sale (KES)</th>
                        <th>Profit (KES)</th>
                    </tr>
                </thead>
                <tbody>
                <?php if ($result && mysqli_num_rows($result) > 0): ?>
                    <?php while ($row = mysqli_fetch_assoc($result)):
                        $discount    = (float)($row['discount'] ?? 0);
                        $total_sale  = ((float)$row['selling_price'] * (float)$row['quantity']) - $discount;
                        $profit      = $total_sale - ((float)$row['buying_price'] * (float)$row['quantity']);

                        $total_sales  += $total_sale;
                        $total_profit += $profit;
                    ?>
                    <tr>
                        <td><?= htmlspecialchars($row['receipt_id']) ?></td>
                        <td><?= date('Y-m-d H:i:s', strtotime($row['sale_datetime'])) ?></td>
                        <td><?= htmlspecialchars($row['cashier']) ?></td>
                        <td><?= htmlspecialchars($row['product_name']) ?></td>
                        <td class="numeric"><?= (float)$row['quantity'] ?></td>
                        <td class="numeric"><?= number_format((float)$row['buying_price'], 2) ?></td>
                        <td class="numeric"><?= number_format((float)$row['selling_price'], 2) ?></td>
                        <td class="numeric"><?= number_format($discount, 2) ?></td>
                        <td class="numeric"><?= number_format($total_sale, 2) ?></td>
                        <td class="numeric"><?= number_format($profit, 2) ?></td>
                    </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="10" style="text-align:center;">No sales recorded for today.</td>
                    </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <div class="totals-box">
        <p>
            <span class="label">Total Sales:</span>
            <span class="value">KES <?= number_format($total_sales, 2) ?></span>
        </p>
        <p>
            <span class="label">Total Profit:</span>
            <span class="value">KES <?= number_format($total_profit, 2) ?></span>
        </p>
    </div>

    <?php include 'footer.php'; ?>

</div> <!-- /content-wrapper -->

<style>
    /* ---------- LAYOUT NEXT TO SIDEBAR ---------- */
    .content-wrapper {
        margin-left: 250px;
        padding: 24px 26px;
        background:
            radial-gradient(circle at top left, rgba(0,255,239,0.08), transparent 55%),
            var(--bg-main, #001f3f);
        min-height: 100vh;
        box-sizing: border-box;
        transition: margin-left 0.3s ease, background 0.3s ease;
        display: flex;
        flex-direction: column;
        gap: 18px;
    }

    /* When sidebar is completely hidden, use full width */
    .content-wrapper.fullwidth {
        margin-left: 0;
    }

    /* Ensure sidebar can be fully hidden (for toggleAdminSidebar) */
    .sidebar.hidden {
        display: none;
    }

    @media (max-width: 900px) {
        .content-wrapper {
            margin-left: 0; /* sidebar overlays on small screens */
            padding: 18px 14px;
        }
    }

    /* ---------- TOPBAR (SAME STYLE AS OTHER PAGES) ---------- */
    .topbar {
        background: var(--bg-sidebar);
        padding: 14px 18px;
        border-radius: 12px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        border: 1px solid #B8860B;
        box-shadow: 0 6px 18px rgba(0,0,0,0.5);
        color: brown;
    }

    .topbar-left {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .topbar-right {
        display: flex;
        align-items: center;
        gap: 10px;
        font-size: 13px;
    }

    .topbar-title {
        font-weight: 600;
        font-size: 15px;
        letter-spacing: 0.03em;
    }

    .menu-btn {
        font-size: 22px;
        cursor: pointer;
        color: var(--accent-gold, #f4b400);
        transition: 0.3s;
        line-height: 1;
    }

    .menu-btn:hover {
        color: #e6c34b;
    }

    .theme-toggle {
        border-radius: 999px;
        border: 1px solid rgba(184,134,11,0.7);
        padding: 6px 12px;
        background: rgba(0,0,0,0.4);
        color: #f9f9f9;
        font-size: 12px;
        cursor: pointer;
    }

    .theme-toggle:hover {
        background: rgba(0,0,0,0.65);
    }

    .topbar-user strong {
        font-weight: 600;
    }

    @media (max-width: 900px) {
        .topbar {
            flex-direction: column;
            align-items: flex-start;
            gap: 8px;
        }
    }

    /* ---------- PAGE HEADER ---------- */
    .page-header {
        display: flex;
        justify-content: center;
        margin-bottom: 4px;
        text-align: center;
    }

    .page-header-center {
        display: flex;
        flex-direction: column;
        gap: 4px;
    }

    .page-title {
        font-size: 22px;
        font-weight: 600;
        color: var(--text-heading);
    }

    .page-subtitle {
        font-size: 13px;
        color: var(--accent-gold, #f4b400);
    }

    /* ---------- CARD & TABLE ---------- */
    .page-card {
        background: var(--bg-card);
        border-radius: 14px;
        padding: 18px 22px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.35);
        border: 1px solid #0a4a85;
        color: var(--text-main);
    }

    body[data-theme="light"] .page-card {
        box-shadow: 0 12px 30px rgba(15,23,42,0.12);
        border-color: rgba(148,163,184,0.55);
    }

    .page-card-title {
        font-size: 16px;
        font-weight: 500;
        margin-bottom: 10px;
        color: var(--text-heading);
    }

    .table-wrapper {
        width: 100%;
        overflow-x: auto;
        margin-top: 6px;
    }

    .today-sales-table {
        width: 100%;
        min-width: 1100px;
        border-collapse: collapse;
    }

    .today-sales-table thead tr {
        background: var(--bg-table-head);
    }

    .today-sales-table th,
    .today-sales-table td {
        padding: 10px 12px;
        border: 1px solid rgba(255,255,255,0.15);
        text-align: center;
        font-size: 13px;
        white-space: nowrap;
    }

    .today-sales-table th {
        color: #ffffff;
        font-weight: 600;
    }

    .today-sales-table tbody tr {
        background: var(--bg-table-row);
    }

    .today-sales-table tbody tr:nth-child(even) {
        background: var(--bg-table-row);
    }

    .today-sales-table tbody tr:hover {
        background: var(--bg-table-hover);
        color: #ffffff;
    }

    body[data-theme="light"] .today-sales-table th {
        color: #111827;
        border-color: rgba(148,163,184,0.5);
    }

    body[data-theme="light"] .today-sales-table td {
        border-color: rgba(148,163,184,0.35);
    }

    body[data-theme="light"] .today-sales-table tbody tr {
        background: var(--bg-table-row);
    }

    body[data-theme="light"] .today-sales-table tbody tr:nth-child(even) {
        background: var(--bg-table-row);
    }

    body[data-theme="light"] .today-sales-table tbody tr:hover {
        background: var(--bg-table-hover);
        color: #111827;
    }

    .numeric {
        text-align: right;
    }

    /* ---------- TOTALS BOX ---------- */
    .totals-box {
        margin: 10px auto 0 auto;
        padding: 14px 18px;
        background: var(--bg-card);
        border-left: 6px solid #f4b400;
        border-radius: 10px;
        text-align: center;
        font-weight: 600;
        font-size: 14px;
        box-shadow: 0 4px 10px rgba(0,0,0,0.3);
        color: var(--text-main);
        max-width: 480px;
    }

    body[data-theme="light"] .totals-box {
        box-shadow: 0 10px 24px rgba(15,23,42,0.12);
        border-left-color: #facc15;
    }

    .totals-box p {
        margin: 4px 0;
    }

    .totals-box span.label {
        color: var(--text-main);
    }

    .totals-box span.value {
        color: #f4b400;
    }

    /* ---------- FOOTER ---------- */
    footer,
    footer.footer {
        text-align: center;
        margin-top: 20px;
    }
</style>

<script>
// SIDEBAR TOGGLE: fully hide/show sidebar and stretch content
function toggleAdminSidebar() {
    const sidebar = document.getElementById('sidebar');
    const wrapper = document.getElementById('content-wrapper');
    if (!sidebar || !wrapper) return;

    const isHidden = sidebar.classList.toggle('hidden');
    if (isHidden) {
        wrapper.classList.add('fullwidth');
    } else {
        wrapper.classList.remove('fullwidth');
    }
}
</script>

</body>
</html>
