<?php
session_start();
if (!isset($_SESSION['username']) || $_SESSION['role'] !== 'admin') {
    header("Location: login.html?error=unauthorized");
    exit();
}

include 'db_connect.php';

$message    = '';
$page_title = "Add New User";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title><?= htmlspecialchars($page_title) ?></title>
    <?php include('head.php'); ?>

    <style>
        body {
            font-family: 'Poppins', Arial, sans-serif;
            background: var(--bg-main);
            margin: 0;
            color: var(--text-main);
        }

        /* Content shifted to the right of sidebar */
        .content-area {
            margin-left: 260px;
            padding: 25px 30px;
        }

        @media(max-width: 768px) {
            .content-area {
                margin-left: 80px;
                padding: 20px;
            }
        }

        /* Form container as themed card */
        .form-container {
            width: 420px;
            background: var(--bg-card);
            margin: 20px auto;
            padding: 24px 26px;
            border-radius: 12px;
            box-shadow: 0 6px 15px rgba(0,0,0,0.4);
            border: 1px solid #0a4a85;
            color: var(--text-main);
        }

        body[data-theme="light"] .form-container {
            border-color: rgba(148,163,184,0.55);
            box-shadow: 0 12px 28px rgba(15,23,42,0.10);
        }

        h2 {
            text-align: center;
            color: var(--text-heading);
            font-weight: 600;
            margin-bottom: 16px;
        }

        label {
            display: block;
            font-weight: 500;
            color: var(--text-main);
            margin-top: 10px;
            margin-bottom: 4px;
            font-size: 14px;
        }

        input,
        select {
            width: 100%;
            padding: 9px 10px;
            margin-top: 2px;
            border-radius: 6px;
            border: 1px solid #0a4a85;
            font-size: 14px;
            background: var(--bg-table-head);
            color: var(--text-main);
        }

        input::placeholder {
            color: rgba(148,163,184,0.9);
        }

        input:focus,
        select:focus {
            outline: none;
            background: var(--bg-table-hover);
            border-color: var(--accent-gold);
        }

        button {
            width: 100%;
            padding: 10px;
            background: var(--accent-gold);
            color: var(--bg-main);
            border: none;
            font-size: 14px;
            border-radius: 6px;
            margin-top: 18px;
            cursor: pointer;
            font-weight: 600;
        }

        button:hover {
            background: var(--accent-gold-soft);
        }

        .error {
            color: #ff6b6b;
            text-align: center;
            margin-bottom: 8px;
            font-weight: 600;
            font-size: 13px;
        }

        .back-link {
            display: block;
            text-align: center;
            margin-top: 16px;
            padding: 9px;
            background: var(--bg-card);
            color: var(--accent-gold);
            border-radius: 6px;
            text-decoration: none;
            font-size: 13px;
            font-weight: 500;
            border: 1px solid #0a4a85;
        }

        body[data-theme="light"] .back-link {
            border-color: rgba(148,163,184,0.55);
        }

        .back-link:hover {
            background: var(--bg-table-hover);
            border-color: var(--accent-gold);
        }

        footer {
            background: transparent;
        }
    </style>
</head>

<body>

<?php include('sidebar.php'); ?>

<div class="content-area">

    <div class="form-container">
        <h2>Add New User</h2>

        <?php if ($message): ?>
            <p class="error"><?= $message; ?></p>
        <?php endif; ?>

        <form method="POST">
            <label>Username</label>
            <input type="text" name="username" required>

            <label>Password</label>
            <input type="password" name="password" required>

            <label>User Role</label>
            <select name="role" required>
                <option value="cashier">Cashier</option>
                <option value="admin">Admin</option>
            </select>

            <button type="submit">Add User</button>
        </form>

        <a href="manage_users.php" class="back-link">← Back to Users</a>
    </div>

</div>

<?php include 'footer.php'; ?>
</body>
</html>
