<?php
session_start();
if (!isset($_SESSION['username']) || $_SESSION['role'] !== 'admin') {
    header("Location: login.html");
    exit();
}

include 'db_connect.php';

$message = "";

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name          = trim($_POST['name']);
    $category      = trim($_POST['category']);
    $buying_price  = $_POST['buying_price'];
    $selling_price = $_POST['selling_price'];
    $quantity      = $_POST['quantity'];

    // Barcode is optional
    $barcode = !empty($_POST['barcode']) ? trim($_POST['barcode']) : NULL;

    if ($name && $category && is_numeric($buying_price) && is_numeric($selling_price) && is_numeric($quantity)) {
        $stmt = $conn->prepare("
            INSERT INTO products (name, category, buying_price, selling_price, quantity, barcode)
            VALUES (?, ?, ?, ?, ?, ?)
        ");
        $stmt->bind_param("ssddis", $name, $category, $buying_price, $selling_price, $quantity, $barcode);

        if ($stmt->execute()) {
            header("Location: manage_products.php?success=Product added");
            exit();
        } else {
            $message = "Error saving product: " . $stmt->error;
        }
        $stmt->close();
    } else {
        $message = "Please fill all fields correctly.";
    }
}

$page_title = "Add Product";
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Add Product</title>

    <?php include('head.php'); ?>

    <style>
        /* Layout next to the global sidebar */
        .content-wrapper {
            margin-left: 250px;
            padding: 30px;
            min-height: 100vh;
            background: var(--bg-main);
            color: var(--text-main);
            box-sizing: border-box;
        }

        .sidebar.collapsed + .content-wrapper {
            margin-left: 70px;
        }

        h2 {
            text-align: center;
            color: var(--text-heading);
            font-weight: 600;
            margin-bottom: 20px;
        }

        /* Form card (theme aware) */
        .form-card {
            width: 420px;
            max-width: 100%;
            margin: 20px auto;
            background: var(--bg-card);
            padding: 20px 24px;
            border-radius: 12px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.35);
            border: 1px solid rgba(0,0,0,0.15);
            color: var(--text-main);
        }

        body:not([data-theme="light"]) .form-card {
            border-color: #0a4a85; /* keep that nice deep blue in dark mode */
        }

        label {
            display: block;
            margin-top: 10px;
            margin-bottom: 4px;
            font-weight: 500;
            color: var(--text-main);
            font-size: 14px;
        }

        .form-card input[type="text"],
        .form-card input[type="number"] {
            width: 100%;
            padding: 8px 10px;
            margin-bottom: 12px;
            border-radius: 4px;
            border: 1px solid rgba(0,0,0,0.2);
            background: var(--bg-table-head);
            color: var(--text-heading);
            font-size: 14px;
            box-sizing: border-box;
        }

        body:not([data-theme="light"]) .form-card input[type="text"],
        body:not([data-theme="light"]) .form-card input[type="number"] {
            border-color: #0a4a85;
        }

        .form-card input[type="text"]::placeholder,
        .form-card input[type="number"]::placeholder {
            color: rgba(148,163,184,0.9);
        }

        .form-card input[type="text"]:focus,
        .form-card input[type="number"]:focus {
            outline: none;
            background: var(--bg-table-hover);
            border-color: var(--accent-gold);
            color: var(--text-heading);
        }

        .form-card button[type="submit"] {
            margin-top: 10px;
            padding: 10px;
            background: var(--accent-gold);
            color: var(--bg-main);
            border: none;
            width: 100%;
            font-weight: 600;
            cursor: pointer;
            border-radius: 6px;
            font-size: 14px;
        }

        .form-card button[type="submit"]:hover {
            background: var(--accent-gold-soft);
        }

        .message {
            text-align: center;
            color: #b91c1c;
            margin-bottom: 10px;
            font-size: 14px;
        }

        .back {
            text-align: center;
            margin-top: 15px;
        }

        .back a {
            color: var(--accent-gold);
            text-decoration: none;
            font-weight: 500;
            font-size: 14px;
        }

        .back a:hover {
            text-decoration: underline;
        }

        @media (max-width: 900px) {
            .content-wrapper {
                margin-left: 0;
                padding: 20px 16px;
            }
            .sidebar.collapsed + .content-wrapper {
                margin-left: 70px;
            }
        }
    </style>
</head>
<body>

<?php include("sidebar.php"); ?>

<div class="content-wrapper">
    <h2>Add Product</h2>

    <?php if ($message): ?>
        <div class="message"><?php echo $message; ?></div>
    <?php endif; ?>

    <form method="POST" action="" class="form-card">
        <label>Product Name</label>
        <input type="text" name="name" required>

        <label>Category</label>
        <input type="text" name="category" required>

        <label>Buying Price</label>
        <input type="number" step="0.01" name="buying_price" required>

        <label>Selling Price</label>
        <input type="number" step="0.01" name="selling_price" required>

        <label>Quantity</label>
        <input type="number" name="quantity" required>

        <label>Barcode (optional)</label>
        <input type="text" name="barcode" placeholder="Scan or type barcode">

        <button type="submit">Add Product</button>
    </form>

    <div class="back">
        <a href="manage_products.php">← Back to Product List</a>
    </div>

    <?php include 'footer.php'; ?>
</div>

</body>
</html>
